/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import com.google.common.cache.Cache;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageManager {
    private static final Logger logger = LoggerFactory.getLogger(ImageManager.class);
    private static final ImageManager instance = new ImageManager();
    private final Cache<String, Image> _cachedImageIcons = CollectionUtils2.createCache((int)500, (long)300L);
    private final ResourceManager resourceManager = ResourceManager.get();

    public static ImageManager get() {
        return instance;
    }

    @Deprecated
    public static ImageManager getInstance() {
        return ImageManager.get();
    }

    private ImageManager() {
    }

    public ImageIcon getImageIcon(String imagePath, ClassLoader ... classLoaders) {
        if (imagePath.endsWith(".gif")) {
            URL url = this.resourceManager.getUrl(imagePath, classLoaders);
            return new ImageIcon(url);
        }
        return new ImageIcon(this.getImage(imagePath, classLoaders));
    }

    public ImageIcon getImageIcon(String imagePath, int newWidth, ClassLoader ... classLoaders) {
        return new ImageIcon(this.getImage(imagePath, newWidth, classLoaders));
    }

    public Image getImage(String imagePath, ClassLoader ... classLoaders) {
        Image image = (Image)this._cachedImageIcons.getIfPresent((Object)imagePath);
        if (image == null) {
            URL url = this.resourceManager.getUrl(imagePath, classLoaders);
            if (url == null && classLoaders != null && classLoaders.length > 0) {
                return this.getImage(imagePath, new ClassLoader[0]);
            }
            if (url == null) {
                logger.warn("Image path ({}) could not be resolved", (Object)imagePath);
                throw new IllegalArgumentException("Could not read image: '" + imagePath + "' (url could not be resolved)");
            }
            logger.debug("Image path ({}) resolved to url: {}", (Object)imagePath, (Object)url);
            try {
                image = ImageIO.read(url);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read image from url:" + url);
            }
            if (image == null) {
                throw new IllegalArgumentException("Could not read image: " + imagePath + " (url: " + url + ")");
            }
        }
        this._cachedImageIcons.put((Object)imagePath, (Object)image);
        return image;
    }

    public Image getImage(String imagePath, int newWidth, ClassLoader ... classLoaders) {
        Image image = (Image)this._cachedImageIcons.getIfPresent((Object)(imagePath + ",width=" + newWidth));
        if (image == null) {
            image = this.getImage(imagePath, classLoaders);
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width > newWidth) {
                int newHeight = newWidth * height / width;
                image = image.getScaledInstance(newWidth, newHeight, 4);
                this._cachedImageIcons.put((Object)(imagePath + ",width=" + newWidth), (Object)image);
            }
        }
        return image;
    }
}

