/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.metal.MetalButtonUI;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.DCTaskPaneContainer;
import org.datacleaner.widgets.PopupButton;
import org.elasticsearch.common.base.Strings;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTextArea;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.plaf.StatusBarUI;
import org.jdesktop.swingx.plaf.basic.BasicStatusBarUI;
import org.jdesktop.swingx.plaf.metal.MetalStatusBarUI;
import org.jdesktop.swingx.prompt.PromptSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WidgetFactory {
    public static final int TEXT_FIELD_COLUMNS = 17;
    private static final Logger logger = LoggerFactory.getLogger(WidgetFactory.class);

    public static JMenu createMenu(String text, char mnemonic) {
        JMenu menu = new JMenu();
        menu.setText(text);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public static JMenuItem createMenuItem(String text, Icon icon) {
        JMenuItem menu = new JMenuItem();
        menu.setText(text);
        if (icon != null) {
            menu.setIcon(icon);
        }
        return menu;
    }

    public static JMenuItem createMenuItem(String text, String iconPath) {
        ImageIcon icon = null;
        if (iconPath != null) {
            icon = ImageManager.get().getImageIcon(iconPath, 16, new ClassLoader[0]);
        }
        return WidgetFactory.createMenuItem(text, icon);
    }

    private static Icon getButtonIcon(String imagePath) {
        if (Strings.isNullOrEmpty((String)imagePath)) {
            return null;
        }
        ImageIcon icon = ImageManager.get().getImageIcon(imagePath, 22, new ClassLoader[0]);
        return icon;
    }

    public static PopupButton createDarkPopupButton(String text, String imagePath) {
        PopupButton b = new PopupButton(text, WidgetFactory.getButtonIcon(imagePath));
        b.setFocusPainted(false);
        WidgetUtils.setDarkButtonStyle(b);
        return b;
    }

    public static PopupButton createDefaultPopupButton(String text, String imagePath) {
        PopupButton b = new PopupButton(text, WidgetFactory.getButtonIcon(imagePath));
        b.setFocusPainted(false);
        WidgetUtils.setDefaultButtonStyle(b);
        return b;
    }

    private static JButton createBasicButton(String text, Icon icon) {
        JButton b = new JButton();
        if (text != null) {
            b.setText(text);
        }
        if (icon != null) {
            b.setIcon(icon);
        }
        b.setFocusPainted(false);
        return b;
    }

    public static JButton createPrimaryButton(String text, String imagePath) {
        return WidgetFactory.createPrimaryButton(text, WidgetFactory.getButtonIcon(imagePath));
    }

    public static JButton createPrimaryButton(String text, Icon icon) {
        JButton b = WidgetFactory.createBasicButton(text, icon);
        WidgetUtils.setPrimaryButtonStyle(b);
        return b;
    }

    public static JButton createDefaultButton(String text) {
        return WidgetFactory.createDefaultButton(text, (Icon)null);
    }

    public static JButton createDefaultButton(String text, String imagePath) {
        return WidgetFactory.createDefaultButton(text, WidgetFactory.getButtonIcon(imagePath));
    }

    public static JButton createDefaultButton(String text, Icon icon) {
        JButton b = WidgetFactory.createBasicButton(text, icon);
        WidgetUtils.setDefaultButtonStyle(b);
        return b;
    }

    public static JButton createDarkButton(String text, String imagePath) {
        return WidgetFactory.createDarkButton(text, WidgetFactory.getButtonIcon(imagePath));
    }

    public static JButton createDarkButton(String text, Icon icon) {
        JButton b = WidgetFactory.createBasicButton(text, icon);
        WidgetUtils.setDarkButtonStyle(b);
        return b;
    }

    @Deprecated
    public static JButton createButton(String text) {
        return WidgetFactory.createButton(text, (Icon)null);
    }

    @Deprecated
    public static JButton createButton(String text, String imagePath) {
        return WidgetFactory.createDarkButton(text, imagePath);
    }

    @Deprecated
    public static JButton createButton(String text, Icon icon) {
        return WidgetFactory.createDarkButton(text, icon);
    }

    public static JXStatusBar createStatusBar(JComponent comp) {
        JXStatusBar statusBar = new JXStatusBar();
        statusBar.setUI((StatusBarUI)new MetalStatusBarUI());
        statusBar.putClientProperty((Object)BasicStatusBarUI.AUTO_ADD_SEPARATOR, (Object)false);
        statusBar.setBackground(WidgetUtils.BG_COLOR_DARKEST);
        MatteBorder outerBorder = new MatteBorder(1, 0, 0, 0, WidgetUtils.BG_COLOR_LESS_DARK);
        EmptyBorder innerBorder = new EmptyBorder(2, 2, 2, 2);
        statusBar.setBorder((Border)new CompoundBorder(outerBorder, innerBorder));
        JXStatusBar.Constraint c1 = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        statusBar.add((Component)comp, (Object)c1);
        return statusBar;
    }

    public static JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setOpaque(false);
        toolBar.setBorder(null);
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        toolBar.setAlignmentY(0.0f);
        return toolBar;
    }

    public static Component createToolBarSeparator() {
        return Box.createHorizontalGlue();
    }

    public static JButton createSmallButton(String imagePath) {
        return WidgetFactory.createSmallButton(null, imagePath);
    }

    public static JButton createSmallButton(String text, String imagePath) {
        ImageIcon icon = ImageManager.get().getImageIcon(imagePath, 16, new ClassLoader[0]);
        return WidgetFactory.createSmallButton(text, icon);
    }

    public static JButton createSmallButton(Icon icon) {
        return WidgetFactory.createSmallButton(null, icon);
    }

    public static JButton createSmallButton(String text, Icon icon) {
        JButton b = new JButton(icon);
        if (text != null) {
            b.setText(text);
            b.setFont(WidgetUtils.FONT_SMALL);
        }
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setUI(new MetalButtonUI());
        b.setBackground(WidgetUtils.COLOR_WELL_BACKGROUND);
        MatteBorder outerBorder = new MatteBorder(1, 1, 1, 1, WidgetUtils.BG_COLOR_LESS_BRIGHT);
        b.setBorder(new CompoundBorder(outerBorder, new EmptyBorder(2, 4, 2, 4)));
        b.setFocusPainted(false);
        return b;
    }

    public static DCTaskPaneContainer createTaskPaneContainer() {
        DCTaskPaneContainer taskPaneContainer = new DCTaskPaneContainer();
        return taskPaneContainer;
    }

    public static JXTaskPane createTaskPane(String title, String imagePath) {
        ImageIcon icon = Strings.isNullOrEmpty((String)imagePath) ? null : ImageManager.get().getImageIcon(imagePath, 16, new ClassLoader[0]);
        return WidgetFactory.createTaskPane(title, icon);
    }

    public static JXTaskPane createTaskPane(String title, Icon icon) {
        JXTaskPane taskPane = new JXTaskPane();
        Container cp = taskPane.getContentPane();
        ((JComponent)cp).setBorder(new MatteBorder(0, 1, 1, 1, WidgetUtils.BG_COLOR_LESS_DARK));
        taskPane.setFocusable(false);
        taskPane.setTitle(title);
        if (icon != null) {
            taskPane.setIcon(icon);
        }
        return taskPane;
    }

    public static JXTextField createTextField() {
        return WidgetFactory.createTextField(null);
    }

    public static JXTextField createTextField(String promptText) {
        return WidgetFactory.createTextField(promptText, 17);
    }

    public static JXTextField createTextField(String promptText, int columns) {
        JXTextField tf = new JXTextField(promptText);
        tf.setColumns(columns);
        if (promptText != null) {
            tf.setFocusBehavior(PromptSupport.FocusBehavior.SHOW_PROMPT);
            tf.setToolTipText(promptText);
        }
        return tf;
    }

    public static JXTextArea createTextArea(String promptText) {
        JXTextArea ta = new JXTextArea(promptText);
        ta.setColumns(17);
        ta.setRows(6);
        ta.setBorder((Border)new CompoundBorder(WidgetUtils.BORDER_THIN, new EmptyBorder(2, 2, 2, 2)));
        return ta;
    }

    public static JButton createImageButton(ImageIcon icon) {
        JButton button = new JButton(icon);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorder(null);
        button.setOpaque(false);
        return button;
    }

    public static JXCollapsiblePane createCollapsiblePane(JXCollapsiblePane.Direction direction) {
        JXCollapsiblePane collapsiblePane = new JXCollapsiblePane(direction);
        collapsiblePane.setOpaque(false);
        try {
            Field field = JXCollapsiblePane.class.getDeclaredField("wrapper");
            field.setAccessible(true);
            JViewport viewPort = (JViewport)field.get(collapsiblePane);
            viewPort.setOpaque(false);
            JComponent component = (JComponent)viewPort.getView();
            component.setOpaque(false);
        }
        catch (Exception e) {
            logger.info("Failed to make JXCollapsiblePane non-opaque", (Throwable)e);
        }
        return collapsiblePane;
    }

    public static JPasswordField createPasswordField() {
        return WidgetFactory.createPasswordField(17);
    }

    public static JPasswordField createPasswordField(int columns) {
        JPasswordField field = new JPasswordField(columns);
        field.setFont(new Font("LucidaSans", 0, 12));
        return field;
    }
}

