/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.datacleaner.job.AnyComponentRequirement;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.LabelUtils;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.ChangeRequirementMenuBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeRequirementButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ChangeRequirementButton.class);
    private static final ImageManager imageManager = ImageManager.get();
    private static final Icon filterIcon = imageManager.getImageIcon("images/component-types/filter-outcome.png", 22, new ClassLoader[0]);
    private final ComponentBuilder _componentBuilder;

    public ChangeRequirementButton(ComponentBuilder componentBuilder) {
        super("(No requirement)", filterIcon);
        this._componentBuilder = componentBuilder;
        this.addActionListener(this);
        this.updateText();
        WidgetUtils.setDefaultButtonStyle(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPopupMenu popup = new JPopupMenu();
        ChangeRequirementMenuBuilder menuBuilder = new ChangeRequirementMenuBuilder(this._componentBuilder){

            @Override
            protected void onRequirementChanged() {
                ChangeRequirementButton.this.updateText();
            }
        };
        List<JMenuItem> menuItems = menuBuilder.createMenuItems();
        for (JMenuItem menuItem : menuItems) {
            popup.add(menuItem);
        }
        popup.show(this, 0, this.getHeight());
    }

    public void updateText() {
        logger.debug("updateText()");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ComponentRequirement requirement = ChangeRequirementButton.this._componentBuilder.getComponentRequirement();
                if (requirement == null) {
                    ChangeRequirementButton.this.setText("(No requirement)");
                } else if (AnyComponentRequirement.get().equals(requirement)) {
                    ChangeRequirementButton.this.setText("All records");
                } else {
                    ChangeRequirementButton.this.setText(requirement.getSimpleName());
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception e) {
            logger.error("Failed to update ChangeRequirementButton", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "ChangeRequirementButton[jobBuilder=" + LabelUtils.getLabel((ComponentBuilder)this._componentBuilder) + "]";
    }
}

