/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.IconUtils;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.DCLabel;
import org.datacleaner.widgets.tooltip.DCToolTip;
import org.datacleaner.widgets.visualization.JobGraphMetadata;

public class DescriptorMenuItem
extends JMenuItem
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final ComponentDescriptor<?> _descriptor;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final Point2D _coordinate;

    public DescriptorMenuItem(AnalysisJobBuilder analysisJobBuilder, Point2D coordinate, ComponentDescriptor<?> descriptor) {
        this(analysisJobBuilder, coordinate, descriptor, true);
    }

    public DescriptorMenuItem(AnalysisJobBuilder analysisJobBuilder, Point2D coordinate, ComponentDescriptor<?> descriptor, boolean addDefaultActionListener) {
        super(descriptor.getDisplayName());
        this._analysisJobBuilder = analysisJobBuilder;
        this._coordinate = coordinate;
        this._descriptor = descriptor;
        if (addDefaultActionListener) {
            this.addActionListener(this);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Map<String, String> metadata = this._coordinate == null ? null : JobGraphMetadata.createMetadataProperties(this._coordinate);
        this._analysisJobBuilder.addComponent(this._descriptor, null, null, metadata);
    }

    @Override
    public Icon getIcon() {
        return IconUtils.getDescriptorIcon(this._descriptor, 16, true);
    }

    @Override
    public String getToolTipText() {
        return this._descriptor.toString();
    }

    @Override
    public JToolTip createToolTip() {
        DCToolTip toolTip = new DCToolTip(this, this.createToolTipPanel());
        return toolTip;
    }

    protected JComponent createToolTipPanel() {
        DCPanel panel = new DCPanel();
        panel.setOpaque(true);
        panel.setBackground(WidgetUtils.BG_COLOR_DARK);
        JLabel iconLabel = new JLabel(IconUtils.getDescriptorIcon(this._descriptor, 32));
        iconLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
        iconLabel.setOpaque(false);
        JLabel nameLabel = new JLabel(this._descriptor.getDisplayName());
        nameLabel.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        nameLabel.setOpaque(false);
        nameLabel.setFont(WidgetUtils.FONT_HEADER1);
        String description = this._descriptor.getDescription();
        if (StringUtils.isNullOrEmpty((String)description)) {
            WidgetUtils.addToGridBag(iconLabel, panel, 0, 0);
            WidgetUtils.addToGridBag(nameLabel, panel, 1, 0);
        } else {
            String[] lines = description.split("\n");
            WidgetUtils.addToGridBag((Component)iconLabel, (JPanel)panel, 0, 0, 1, lines.length + 1, 17);
            WidgetUtils.addToGridBag(nameLabel, panel, 1, 0);
            int width = 0;
            int height = 0;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                DCLabel label = DCLabel.brightMultiLine(line);
                label.setMaximumWidth(350);
                Dimension ps = label.getPreferredSize();
                height += ps.height + 8;
                width = Math.max(ps.width, width);
                WidgetUtils.addToGridBag(label, panel, 1, i + 1);
            }
            panel.setPreferredSize(new Dimension(width += iconLabel.getPreferredSize().width + 30, height += nameLabel.getPreferredSize().height + 30));
        }
        CompoundBorder border = new CompoundBorder(WidgetUtils.BORDER_THIN, WidgetUtils.BORDER_EMPTY);
        panel.setBorder(border);
        return panel;
    }
}

