/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.table;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.Alignment;
import org.datacleaner.widgets.table.DCTableCellRenderer;
import org.datacleaner.widgets.table.DCTablePanel;
import org.datacleaner.widgets.table.JComponentCellEditor;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCTable
extends JXTable
implements MouseListener {
    private static final Logger logger = LoggerFactory.getLogger(DCTable.class);
    private static final long serialVersionUID = -5376226138423224572L;
    public static final int EDITABLE_TABLE_ROW_HEIGHT = 30;
    private final transient DCTableCellRenderer _tableCellRenderer;
    protected final transient List<JMenuItem> _rightClickMenuItems;
    protected transient DCPanel _panel;
    private ActionListener _copySelectItemsActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowIndex = DCTable.this.getSelectedRow();
            int rowCount = DCTable.this.getSelectedRowCount();
            int colIndex = DCTable.this.getSelectedColumn();
            int colCount = DCTable.this.getSelectedColumnCount();
            DCTable.this.copyToClipboard(rowIndex, colIndex, colCount, rowCount);
        }
    };
    private ActionListener _copyEntireTableActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DCTable.this.copyToClipboard(0, 0, DCTable.this.getColumnCount(), DCTable.this.getRowCount());
        }
    };

    public DCTable(String ... columnNames) {
        super(new Object[0][columnNames.length], (Object[])columnNames);
        this.addHighlighter(WidgetUtils.LIBERELLO_HIGHLIGHTER);
        this.getTableHeader().setReorderingAllowed(true);
        this.setAutoResizeMode(4);
        this.setOpaque(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setColumnControlVisible(true);
        this.setSortable(true);
        this.setEditable(true);
        this.addMouseListener(this);
        this._rightClickMenuItems = this.getCopyMenuItems();
        this._tableCellRenderer = new DCTableCellRenderer(this);
    }

    public DCTable() {
        this(new String[0]);
    }

    public DCTable(TableModel tableModel) {
        this();
        this.setModel(tableModel);
    }

    public DCPanel toPanel(boolean scrolleable) {
        if (this._panel == null) {
            this._panel = new DCTablePanel(this, scrolleable);
        }
        return this._panel;
    }

    public DCPanel toPanel() {
        return this.toPanel(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._panel != null) {
            this._panel.updateUI();
        }
    }

    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        if (this._panel != null) {
            this._panel.updateUI();
        }
    }

    protected List<JMenuItem> getCopyMenuItems() {
        ImageIcon icon = ImageManager.get().getImageIcon("images/actions/copy.png", 16, new ClassLoader[0]);
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        JMenuItem copySelectedItem = new JMenuItem("Copy selected cells to clipboard", icon);
        copySelectedItem.addActionListener(this._copySelectItemsActionListener);
        result.add(copySelectedItem);
        JMenuItem copyTableItem = new JMenuItem("Copy entire table to clipboard", icon);
        copyTableItem.addActionListener(this._copyEntireTableActionListener);
        result.add(copyTableItem);
        return result;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.forwardMouseEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.forwardMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean forwarded = this.forwardMouseEvent(e);
        if (!forwarded) {
            this.consumeMouseClick(e);
        }
    }

    protected void consumeMouseClick(MouseEvent e) {
        int button;
        logger.debug("consumeMouseClick({})", (Object)e);
        if (e.getClickCount() == 1 && ((button = e.getButton()) == 2 || button == 3) && this._rightClickMenuItems != null && this._rightClickMenuItems.size() > 0) {
            JPopupMenu popup = new JPopupMenu();
            for (JMenuItem item : this._rightClickMenuItems) {
                popup.add(item);
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
    }

    private boolean forwardMouseEvent(MouseEvent e) {
        logger.debug("forwardMouseEvent({})", (Object)e);
        int x = e.getX();
        int y = e.getY();
        int col = this.getColumnModel().getColumnIndexAtX(x);
        int row = y / this.getRowHeight();
        if (row >= this.getRowCount()) {
            row = -1;
        }
        if (row == -1 || col == -1) {
            logger.debug("Disregarding mouse event at {},{} (row={},col={})", new Object[]{x, y, row, col});
            return false;
        }
        try {
            Object value = this.getValueAt(row, col);
            if (value instanceof JComponent) {
                JComponent component = (JComponent)value;
                MouseEvent newEvent = SwingUtilities.convertMouseEvent((Component)((Object)this), e, component);
                component.dispatchEvent(newEvent);
                this.repaint();
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException exception) {
            logger.debug("Failed to dispatch event for component because of IndexOutOfBoundsException", (Throwable)exception);
            return false;
        }
    }

    public void copyToClipboard(int rowIndex, int colIndex, int width, int height) {
        StringBuilder sb = new StringBuilder();
        if (rowIndex == 0 && colIndex == 0 && width == this.getColumnCount() && height == this.getRowCount()) {
            for (int i = 0; i < width; ++i) {
                sb.append(this.getColumnName(i));
                if (i >= height - 1) continue;
                sb.append("\t");
            }
            sb.append("\n");
        }
        for (int row = rowIndex; row < rowIndex + height; ++row) {
            for (int col = colIndex; col < colIndex + width; ++col) {
                Object value = this.getValueAt(row, col);
                if (value == null) {
                    value = "";
                } else if (value instanceof JComponent) {
                    value = WidgetUtils.extractText((JComponent)value);
                }
                sb.append(value);
                sb.append("\t");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stsel = new StringSelection(sb.toString());
        clipboard.setContents(stsel, stsel);
    }

    public String getTextValueAt(int row, int column) {
        Object value = this.getValueAt(row, column);
        if (value == null) {
            value = "";
        } else if (value instanceof JComponent) {
            value = WidgetUtils.extractText((JComponent)value);
        }
        return value.toString();
    }

    public Object getValueAt(int row, int column) {
        Object value = super.getValueAt(row, column);
        if (value == null) {
            value = "<null>";
        }
        return value;
    }

    public void setVisibleColumns(int min, int max) {
        for (int i = this.getColumnCount(); i > 0; --i) {
            if (i >= min && i <= max) {
                this.getColumnExt(i - 1).setVisible(true);
                continue;
            }
            this.getColumnExt(i - 1).setVisible(false);
        }
    }

    public DCTableCellRenderer getDCTableCellRenderer() {
        if (this._tableCellRenderer == null) {
            return new DCTableCellRenderer(this);
        }
        return this._tableCellRenderer;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.getDCTableCellRenderer();
    }

    public TableCellEditor getCellEditor(int row, int column) {
        logger.debug("getCellEditor({},{})", (Object)row, (Object)column);
        Object value = this.getValueAt(row, column);
        if (value instanceof JComponent) {
            return JComponentCellEditor.forComponent((JComponent)value);
        }
        return JComponentCellEditor.forComponent(null);
    }

    public void setAlignment(int column, Alignment alignment) {
        this.getDCTableCellRenderer().setAlignment(column, alignment);
    }

    public void selectRows(int ... rowIndexes) {
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        for (int i = 0; i < rowIndexes.length; ++i) {
            int rowIndex = rowIndexes[i];
            if (i == 0) {
                this.setRowSelectionInterval(rowIndex, rowIndex);
                continue;
            }
            this.addRowSelectionInterval(rowIndex, rowIndex);
        }
        selectionModel.setValueIsAdjusting(false);
        this.getColumnModel().getSelectionModel().setValueIsAdjusting(true);
        this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        this.getColumnModel().getSelectionModel().setValueIsAdjusting(false);
    }

    public void autoSetHorizontalScrollEnabled() {
        if (this.getColumnCount() >= 9) {
            this.setHorizontalScrollEnabled(true);
        } else {
            this.setHorizontalScrollEnabled(false);
        }
    }
}

