/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.table.DCTable;

public final class DCTablePanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final JScrollPane _scrollPane;
    private final DCTable _table;

    public DCTablePanel(DCTable table, boolean scrolleable) {
        this._table = table;
        this.setLayout(new BorderLayout());
        JTableHeader tableHeader = table.getTableHeader();
        this.add((Component)tableHeader, "North");
        tableHeader.setBorder(WidgetUtils.BORDER_TABLE_PANEL);
        table.setBorder(WidgetUtils.BORDER_TABLE_PANEL);
        if (scrolleable) {
            this._scrollPane = WidgetUtils.scrolleable((JComponent)((Object)table));
            this.add((Component)this._scrollPane, "Center");
        } else {
            this._scrollPane = null;
            this.add((Component)((Object)table), "Center");
        }
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._scrollPane == null) {
            return super.getPreferredSize();
        }
        Dimension tableSize = this._table.getPreferredSize();
        Dimension headerSize = this._table.getTableHeader().getPreferredSize();
        Dimension d = new Dimension();
        d.width = Math.max(tableSize.width, headerSize.width);
        d.height = headerSize.height + this._table.getRowHeight() * this._table.getRowCount();
        Insets insets = this.getInsets();
        d.height = d.height + insets.top + insets.bottom;
        JScrollBar scrollBar = this._scrollPane.getHorizontalScrollBar();
        int scrollbarHeight = scrollBar.getHeight();
        d.height += scrollbarHeight;
        return d;
    }

    @Override
    public void setVisible(boolean visible) {
        this._table.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this._table.isVisible();
    }
}

