/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.visualization;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.datacleaner.components.convert.ConvertToNumberTransformer;
import org.datacleaner.job.builder.AnalysisJobBuilder;

public class JobGraphMetadata {
    public static final String METADATA_PROPERTY_COORDINATES_X = "CoordinatesX";
    public static final String METADATA_PROPERTY_COORDINATES_Y = "CoordinatesY";

    public static Point getPointForTable(AnalysisJobBuilder analysisJobBuilder, Table table) {
        String postFix = JobGraphMetadata.getTablePostFix(table);
        Map metadataProperties = analysisJobBuilder.getMetadataProperties();
        String xString = (String)metadataProperties.get(METADATA_PROPERTY_COORDINATES_X + postFix);
        String yString = (String)metadataProperties.get(METADATA_PROPERTY_COORDINATES_Y + postFix);
        Number x = ConvertToNumberTransformer.transformValue((Object)xString);
        Number y = ConvertToNumberTransformer.transformValue((Object)yString);
        if (x != null && y != null) {
            return new Point(x.intValue(), y.intValue());
        }
        return null;
    }

    public static void setPointForTable(AnalysisJobBuilder analysisJobBuilder, Table table, Number x, Number y) {
        String postFix = JobGraphMetadata.getTablePostFix(table);
        Map metadataProperties = analysisJobBuilder.getMetadataProperties();
        metadataProperties.put(METADATA_PROPERTY_COORDINATES_X + postFix, "" + x.intValue());
        metadataProperties.put(METADATA_PROPERTY_COORDINATES_Y + postFix, "" + y.intValue());
    }

    private static String getTablePostFix(Table table) {
        Schema schema = table.getSchema();
        String postFix = schema == null ? "." + table.getName() : "." + schema.getName() + "." + table.getName();
        return postFix;
    }

    public static Map<String, String> createMetadataProperties(int x, int y) {
        HashMap<String, String> metadataProperties = new HashMap<String, String>();
        metadataProperties.put(METADATA_PROPERTY_COORDINATES_X, "" + x);
        metadataProperties.put(METADATA_PROPERTY_COORDINATES_Y, "" + y);
        return metadataProperties;
    }

    public static Map<String, String> createMetadataProperties(Point2D p) {
        if (p == null) {
            return null;
        }
        int x = (int)p.getX();
        int y = (int)p.getY();
        return JobGraphMetadata.createMetadataProperties(x, y);
    }
}

