/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.panels.DCBannerPanel;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.windows.DCWindow;

public abstract class AbstractDialog
extends JDialog
implements DCWindow,
WindowListener {
    private static final long serialVersionUID = 1L;
    private volatile boolean initialized = false;
    private final WindowContext _windowContext;
    private Image _bannerImage;
    private volatile Color _backgroundColor = WidgetUtils.COLOR_ALTERNATIVE_BACKGROUND;
    private DCBannerPanel _banner;

    public AbstractDialog(WindowContext windowContext) {
        this(windowContext, null);
    }

    public AbstractDialog(WindowContext windowContext, Image bannerImage) {
        this.setModal(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setResizable(this.isWindowResizable());
        this._windowContext = windowContext;
        this._bannerImage = bannerImage;
    }

    public void setBannerImage(Image bannerImage) {
        this._bannerImage = bannerImage;
        this._banner = null;
    }

    public Image getBannerImage() {
        return this._bannerImage;
    }

    protected DCBannerPanel getBanner() {
        if (this._banner == null && this._bannerImage != null) {
            this._banner = this.createBanner(this._bannerImage);
        }
        return this._banner;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    @Override
    public void open() {
        this.setVisible(true);
    }

    @Override
    public void close() {
        if (this.isVisible()) {
            this.dispose();
        }
    }

    protected void updateWindowTitle() {
        String windowTitle = this.getWindowTitle();
        if (windowTitle == null) {
            windowTitle = "DataCleaner";
        } else if (windowTitle.indexOf("DataCleaner") == -1) {
            windowTitle = windowTitle + " | DataCleaner";
        }
        this.setTitle(windowTitle);
    }

    protected void initialize() {
        this.updateWindowTitle();
        this.setIconImage(this.getWindowIcon());
        this.setResizable(this.isWindowResizable());
        JComponent content = this.getWindowContent();
        this.getContentPane().add(content);
        this.getContentPane().setPreferredSize(content.getPreferredSize());
        this.pack();
        WidgetUtils.centerOnScreen(this);
        if (this._windowContext != null) {
            this._windowContext.onShow(this);
        }
    }

    @Override
    public final void setVisible(boolean b) {
        if (!b) {
            throw new UnsupportedOperationException("Window does not support hiding, consider using dispose()");
        }
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        super.setVisible(true);
    }

    protected boolean isWindowResizable() {
        return false;
    }

    @Override
    public Image getWindowIcon() {
        return ImageManager.get().getImage("images/window/app-icon.png", new ClassLoader[0]);
    }

    protected final JComponent getWindowContent() {
        int bannerHeight;
        DCPanel panel = new DCPanel(this._backgroundColor);
        panel.setLayout(new BorderLayout());
        DCBannerPanel banner = this.getBanner();
        if (banner == null) {
            bannerHeight = 0;
        } else {
            panel.add((Component)banner, "North");
            bannerHeight = banner.getPreferredSize().height;
        }
        JComponent dialogContent = this.getDialogContent();
        panel.add((Component)dialogContent, "Center");
        panel.setPreferredSize(this.getDialogWidth(), bannerHeight + dialogContent.getPreferredSize().height + this.getDialogHeightBuffer());
        return panel;
    }

    protected int getDialogHeightBuffer() {
        return 0;
    }

    protected DCBannerPanel createBanner(Image bannerImage) {
        if (bannerImage == null) {
            return null;
        }
        DCBannerPanel bannerPanel = new DCBannerPanel(bannerImage, this.getBannerTitle());
        return bannerPanel;
    }

    protected abstract String getBannerTitle();

    protected abstract int getDialogWidth();

    protected abstract JComponent getDialogContent();

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public final void windowClosing(WindowEvent e) {
        boolean dispose = this.onWindowClosing();
        if (dispose) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this._windowContext != null) {
            this._windowContext.onDispose(this);
        }
        super.dispose();
    }

    @Override
    public WindowContext getWindowContext() {
        return this._windowContext;
    }

    protected boolean onWindowClosing() {
        return true;
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public Component toComponent() {
        return this;
    }
}

