/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.windows;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.Alignment;
import org.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.action.OpenBrowserAction;

public class ErrorDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final String _shortMessage;
    private final String _detailedMessage;

    public ErrorDialog(String shortMessage, String detailedMessage) {
        super(null, ImageManager.get().getImage("images/window/banner-error.png", new ClassLoader[0]));
        this._shortMessage = shortMessage;
        this._detailedMessage = detailedMessage;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return this._shortMessage;
    }

    @Override
    protected String getBannerTitle() {
        return this._shortMessage;
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    @Override
    protected JComponent getDialogContent() {
        JXEditorPane detailedMessagePane = new JXEditorPane("text/html", this._detailedMessage);
        detailedMessagePane.setEditable(false);
        detailedMessagePane.setOpaque(false);
        detailedMessagePane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                String href;
                if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType()) && !Strings.isNullOrEmpty((String)(href = event.getDescription()))) {
                    OpenBrowserAction openBrowserAction = new OpenBrowserAction(href);
                    openBrowserAction.actionPerformed(null);
                }
            }
        });
        detailedMessagePane.setBorder((Border)new EmptyBorder(10, 10, 40, 10));
        JButton button = WidgetFactory.createPrimaryButton("Close", "images/actions/close_bright.png");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.close();
            }
        });
        DCPanel panel = new DCPanel(WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        panel.setLayout(new BorderLayout());
        panel.add((Component)detailedMessagePane, "Center");
        panel.add((Component)DCPanel.flow(Alignment.CENTER, button), "South");
        return panel;
    }
}

