/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetTableModel;
import org.apache.metamodel.query.Query;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.NumberDocument;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.DCLabel;
import org.datacleaner.widgets.table.DCTable;
import org.datacleaner.windows.AbstractWindow;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jdesktop.swingx.JXTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWindow
extends AbstractWindow {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(QueryWindow.class);
    private final Datastore _datastore;
    private final RSyntaxTextArea _queryTextArea;
    private final DCPanel _upperPanel;
    private final DCPanel _centerPanel;
    private final JButton _queryButton;
    private final DCTable _table;
    private final JXTextField _limitTextField;

    public QueryWindow(WindowContext windowContext, Datastore datastore, String query) {
        super(windowContext);
        this._datastore = datastore;
        this._queryTextArea = new RSyntaxTextArea(5, 17);
        this._queryTextArea.setSyntaxEditingStyle("text/sql");
        this._queryTextArea.setText(query);
        this._limitTextField = WidgetFactory.createTextField(null, 3);
        this._limitTextField.setDocument((Document)new NumberDocument(false, false));
        this._limitTextField.setText("500");
        this._table = new DCTable();
        this._queryButton = WidgetFactory.createPrimaryButton("Execute query", "images/model/query.png");
        this._queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String queryString = QueryWindow.this._queryTextArea.getText();
                logger.debug("Query being parsed: {}", (Object)queryString);
                try (DatastoreConnection con = QueryWindow.this._datastore.openConnection();){
                    DataContext dataContext = con.getDataContext();
                    Query q = dataContext.parseQuery(queryString);
                    logger.info("Parsed query: {}", (Object)q);
                    String limitString = QueryWindow.this._limitTextField.getText();
                    if (!StringUtils.isNullOrEmpty((String)limitString)) {
                        int limit = Integer.parseInt(limitString);
                        q.setMaxRows(Integer.valueOf(limit));
                    }
                    DataSet dataSet = dataContext.executeQuery(q);
                    QueryWindow.this._centerPanel.setVisible(true);
                    QueryWindow.this._table.setModel((TableModel)new DataSetTableModel(dataSet));
                }
                catch (MetaModelException e) {
                    WidgetUtils.showErrorMessage("Failed to execute query", e.getMessage(), e);
                }
            }
        });
        this._centerPanel = this._table.toPanel();
        this._centerPanel.setVisible(false);
        DCPanel decoratedLimitTextField = WidgetUtils.decorateWithShadow((JComponent)this._limitTextField, false, 0);
        DCPanel buttonPanel = new DCPanel();
        WidgetUtils.addToGridBag(DCLabel.dark("Max rows:"), buttonPanel, 1, 1, 10);
        WidgetUtils.addToGridBag(decoratedLimitTextField, buttonPanel, 2, 1, 10);
        WidgetUtils.addToGridBag((Component)this._queryButton, (JPanel)buttonPanel, 1, 2, 2, 1);
        JScrollPane scrolledTextArea = new JScrollPane((Component)this._queryTextArea);
        DCPanel decoratedTextField = WidgetUtils.decorateWithShadow(scrolledTextArea);
        this._upperPanel = new DCPanel();
        this._upperPanel.setLayout(new BorderLayout());
        this._upperPanel.add((Component)decoratedTextField, "Center");
        this._upperPanel.add((Component)buttonPanel, "East");
    }

    @Override
    public String getWindowTitle() {
        return "Query " + this._datastore.getName();
    }

    @Override
    public Image getWindowIcon() {
        return ImageManager.get().getImage("images/model/query.png", new ClassLoader[0]);
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected boolean isCentered() {
        return true;
    }

    @Override
    protected JComponent getWindowContent() {
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)this._upperPanel, "North");
        outerPanel.add((Component)this._centerPanel, "Center");
        outerPanel.setPreferredSize(new Dimension(900, 400));
        return outerPanel;
    }
}

