/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.datacleaner.actions.DisplayOutputWritersAction;
import org.datacleaner.api.Component;
import org.datacleaner.api.ComponentCategory;
import org.datacleaner.components.categories.WriteDataCategory;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.desktop.api.PrecedingComponentConsumer;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.ImageManager;
import org.datacleaner.widgets.DescriptorMenu;
import org.datacleaner.widgets.PopupButton;

public class DisplayOptionsForFilterOutcomeActionListener
extends DisplayOutputWritersAction
implements ActionListener {
    private static final ImageManager imageManager = ImageManager.get();
    private final FilterComponentBuilder<?, ?> _filterJobBuilder;
    private final String _categoryName;
    private final PopupButton _popupButton;

    public DisplayOptionsForFilterOutcomeActionListener(PopupButton popupButton, FilterComponentBuilder<?, ?> filterJobBuilder, String categoryName) {
        super(filterJobBuilder.getAnalysisJobBuilder());
        this._filterJobBuilder = filterJobBuilder;
        this._categoryName = categoryName;
        this._popupButton = popupButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterOutcome filterOutcome = this._filterJobBuilder.getFilterOutcome((Object)((FilterDescriptor)this._filterJobBuilder.getDescriptor()).getOutcomeCategoryByName(this._categoryName));
        SimpleComponentRequirement requirement = new SimpleComponentRequirement(filterOutcome);
        DescriptorMenu writeDataMenu = new DescriptorMenu((ComponentCategory)new WriteDataCategory());
        List<JMenuItem> writerDataMenuItems = this.createMenuItems();
        for (JMenuItem menuItem : writerDataMenuItems) {
            writeDataMenu.add(menuItem);
        }
        final AnalysisJobBuilder analysisJobBuilder = this._filterJobBuilder.getAnalysisJobBuilder();
        JMenuItem setAsDefaultOutcomeMenuItem = new JMenuItem("Set as default requirement");
        setAsDefaultOutcomeMenuItem.setToolTipText("Makes this filter outcome the default choice for other components in the job.");
        ComponentRequirement existingDefaultRequirement = analysisJobBuilder.getDefaultRequirement();
        if (requirement.equals(existingDefaultRequirement)) {
            setAsDefaultOutcomeMenuItem.setIcon(imageManager.getImageIcon("images/status/valid.png", 16, new ClassLoader[0]));
        }
        setAsDefaultOutcomeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Enum category = ((FilterDescriptor)DisplayOptionsForFilterOutcomeActionListener.this._filterJobBuilder.getDescriptor()).getOutcomeCategoryByName(DisplayOptionsForFilterOutcomeActionListener.this._categoryName);
                FilterOutcome outcome = DisplayOptionsForFilterOutcomeActionListener.this._filterJobBuilder.getFilterOutcome((Object)category);
                analysisJobBuilder.setDefaultRequirement(outcome);
            }
        });
        JPopupMenu popup = this._popupButton.getMenu();
        popup.removeAll();
        popup.add(writeDataMenu);
        popup.add(setAsDefaultOutcomeMenuItem);
    }

    @Override
    protected void configure(AnalysisJobBuilder analysisJobBuilder, ComponentBuilder componentBuilder) {
        Component component = componentBuilder.getComponentInstance();
        if (component instanceof PrecedingComponentConsumer) {
            LifeCycleHelper helper = new LifeCycleHelper(analysisJobBuilder.getConfiguration(), null, true);
            helper.assignProvidedProperties(componentBuilder.getDescriptor(), (Object)component);
            ((PrecedingComponentConsumer)component).configureForFilterOutcome(analysisJobBuilder, (FilterDescriptor)this._filterJobBuilder.getDescriptor(), this._categoryName);
        }
        FilterOutcome outcome = this._filterJobBuilder.getFilterOutcome((Object)this._categoryName);
        SimpleComponentRequirement requirement = new SimpleComponentRequirement(outcome);
        componentBuilder.setComponentRequirement((ComponentRequirement)requirement);
    }
}

