/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.components.maxrows.MaxRowsFilter;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.AnalyzerComponentBuilder;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.AnalysisRunnerImpl;
import org.datacleaner.panels.TransformerComponentBuilderPresenter;
import org.datacleaner.util.PreviewTransformedDataAnalyzer;
import org.datacleaner.util.SourceColumnFinder;
import org.datacleaner.windows.DataSetWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreviewTransformedDataActionListener
implements ActionListener,
Callable<TableModel> {
    private static final Logger logger = LoggerFactory.getLogger(PreviewTransformedDataActionListener.class);
    public static final int DEFAULT_PREVIEW_ROWS = 200;
    private final TransformerComponentBuilderPresenter _transformerJobBuilderPresenter;
    private final TransformerComponentBuilder<?> _transformerJobBuilder;
    private final WindowContext _windowContext;
    private final int _previewRows;
    private DataSetWindow _latestWindow;

    public PreviewTransformedDataActionListener(WindowContext windowContext, TransformerComponentBuilder<?> transformerJobBuilder) {
        this(windowContext, null, transformerJobBuilder);
    }

    public PreviewTransformedDataActionListener(WindowContext windowContext, TransformerComponentBuilderPresenter transformerJobBuilderPresenter, TransformerComponentBuilder<?> transformerJobBuilder) {
        this(windowContext, transformerJobBuilderPresenter, transformerJobBuilder, 200);
    }

    public PreviewTransformedDataActionListener(WindowContext windowContext, TransformerComponentBuilderPresenter transformerJobBuilderPresenter, TransformerComponentBuilder<?> transformerJobBuilder, int previewRows) {
        this._windowContext = windowContext;
        this._transformerJobBuilderPresenter = transformerJobBuilderPresenter;
        this._transformerJobBuilder = transformerJobBuilder;
        this._previewRows = previewRows;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSetWindow existingWindow = this._latestWindow;
        if (existingWindow != null) {
            existingWindow.close();
            this._latestWindow = null;
        }
        DataSetWindow window = new DataSetWindow("Preview of transformed dataset", this, this._windowContext);
        window.open();
        this._latestWindow = window;
    }

    @Override
    public TableModel call() throws Exception {
        List sourceColumns;
        if (this._transformerJobBuilderPresenter != null) {
            this._transformerJobBuilderPresenter.applyPropertyValues();
        }
        AnalysisJobBuilder ajb = this.copy(this._transformerJobBuilder.getAnalysisJobBuilder());
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(ajb);
        TransformerComponentBuilder<?> tjb = this.findTransformerComponentBuilder(ajb, this._transformerJobBuilder);
        List tables = ajb.getSourceTables();
        if (tables.size() > 1) {
            Table originatingTable = sourceColumnFinder.findOriginatingTable((InputColumn)tjb.getOutputColumns().get(0));
            tables.remove(originatingTable);
            for (Table otherTable : tables) {
                ajb.removeSourceTable(otherTable);
            }
        }
        if ((sourceColumns = ajb.getSourceColumns()).isEmpty()) {
            logger.error("No source columns left after removing irrelevant source tables. Component: {}", this._transformerJobBuilder);
            return new DefaultTableModel(0, 0);
        }
        ajb.removeAllAnalyzers();
        AnalyzerComponentBuilder rowCollector = (AnalyzerComponentBuilder)((AnalyzerComponentBuilder)ajb.addAnalyzer(Descriptors.ofAnalyzer(PreviewTransformedDataAnalyzer.class)).addInputColumns((Collection)tjb.getInputColumns())).addInputColumns((Collection)tjb.getOutputColumns());
        if (tjb.getComponentRequirement() != null) {
            rowCollector.setComponentRequirement(tjb.getComponentRequirement());
        }
        FilterComponentBuilder maxRowFilter = ajb.addFilter(MaxRowsFilter.class);
        maxRowFilter.setName(this.getClass().getName() + "-MaxRows");
        ((MaxRowsFilter)maxRowFilter.getComponentInstance()).setMaxRows(this._previewRows);
        ajb.setDefaultRequirement(maxRowFilter, (Enum)MaxRowsFilter.Category.VALID);
        Object[] columnNames = new String[rowCollector.getInputColumns().size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = ((InputColumn)rowCollector.getInputColumns().get(i)).getName();
        }
        AnalysisRunnerImpl runner = new AnalysisRunnerImpl(ajb.getConfiguration());
        AnalysisResultFuture resultFuture = runner.run(ajb.toAnalysisJob());
        resultFuture.await();
        if (resultFuture.isErrornous()) {
            List errors = resultFuture.getErrors();
            Throwable firstError = (Throwable)errors.get(0);
            logger.error("Error occurred while running preview data job: {}", (Object)firstError.getMessage());
            for (Throwable throwable : errors) {
                logger.info("Preview data error", throwable);
            }
            if (firstError instanceof Exception) {
                throw (Exception)firstError;
            }
            throw new IllegalStateException(firstError);
        }
        List results = resultFuture.getResults(PreviewTransformedDataAnalyzer.class);
        assert (results.size() == 1);
        PreviewTransformedDataAnalyzer result = (PreviewTransformedDataAnalyzer)results.get(0);
        List rows = result.getList();
        DefaultTableModel tableModel = new DefaultTableModel(columnNames, rows.size());
        int rowIndex = 0;
        for (Object[] row : rows) {
            if (row != null) {
                for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                    tableModel.setValueAt(row[columnIndex], rowIndex, columnIndex);
                }
            }
            ++rowIndex;
        }
        return tableModel;
    }

    private TransformerComponentBuilder<?> findTransformerComponentBuilder(AnalysisJobBuilder ajb, TransformerComponentBuilder<?> transformerJobBuilder) {
        AnalysisJobBuilder analysisJobBuilder = this._transformerJobBuilder.getAnalysisJobBuilder();
        int transformerIndex = analysisJobBuilder.getTransformerComponentBuilders().indexOf(this._transformerJobBuilder);
        return (TransformerComponentBuilder)ajb.getTransformerComponentBuilders().get(transformerIndex);
    }

    private AnalysisJobBuilder copy(AnalysisJobBuilder original) {
        AnalysisJob analysisJob = original.withoutListeners().toAnalysisJob(false);
        AnalysisJobBuilder ajb = new AnalysisJobBuilder(original.getConfiguration(), analysisJob);
        return ajb;
    }
}

