/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.HasName;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.connection.Datastore;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.windows.QueryWindow;

public class QueryActionListener
implements ActionListener {
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final Table _table;
    private final WindowContext _windowContext;
    private final Collection<? extends HasName> _columns;

    public QueryActionListener(WindowContext windowContext, AnalysisJobBuilder analysisJobBuilder, Table table) {
        this(windowContext, analysisJobBuilder, table, null);
    }

    public QueryActionListener(WindowContext windowContext, AnalysisJobBuilder analysisJobBuilder, Table table, Collection<? extends HasName> columns) {
        this._windowContext = windowContext;
        this._analysisJobBuilder = analysisJobBuilder;
        this._table = table;
        this._columns = columns;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Datastore datastore = this._analysisJobBuilder.getDatastore();
        StringBuilder initialQuery = new StringBuilder("SELECT ");
        if (this._columns == null || this._columns.isEmpty()) {
            initialQuery.append("*");
        } else {
            boolean first = true;
            for (HasName hasName : this._columns) {
                if (!first) {
                    initialQuery.append(", ");
                }
                initialQuery.append("a.");
                initialQuery.append(hasName.getName());
                first = false;
            }
        }
        String fromClause = this._table.getQualifiedLabel();
        if (fromClause.contains(" ")) {
            fromClause = this._table.getName();
        }
        initialQuery.append("\nFROM " + fromClause + " a");
        QueryWindow window = new QueryWindow(this._windowContext, datastore, initialQuery.toString());
        window.open();
    }
}

