/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.UnconfiguredConfiguredPropertyException;
import org.datacleaner.panels.ComponentBuilderPresenter;
import org.datacleaner.panels.ConfiguredPropertyTaskPane;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.panels.OutputDataStreamsViewer;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.DCTaskPaneContainer;
import org.datacleaner.widgets.properties.PropertyWidget;
import org.datacleaner.widgets.properties.PropertyWidgetCollection;
import org.datacleaner.widgets.properties.PropertyWidgetFactory;
import org.datacleaner.widgets.properties.PropertyWidgetPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentBuilderPanel
extends DCPanel
implements ComponentBuilderPresenter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponentBuilderPanel.class);
    private final ImageManager imageManager = ImageManager.get();
    private final DCTaskPaneContainer _taskPaneContainer = WidgetFactory.createTaskPaneContainer();
    private final PropertyWidgetFactory _propertyWidgetFactory;
    private final PropertyWidgetCollection _propertyWidgetCollection;
    private final ComponentBuilder _componentBuilder;
    private final ComponentDescriptor<?> _descriptor;
    private final JComponent _buttonPanel;
    private final OutputDataStreamsViewer _outputDataStreamsViewer;
    private JXTaskPane _outputDataStreamsTaskPane;

    protected AbstractComponentBuilderPanel(String watermarkImagePath, ComponentBuilder componentBuilder, PropertyWidgetFactory propertyWidgetFactory) {
        this(ImageManager.get().getImage(watermarkImagePath, new ClassLoader[0]), 95, 95, componentBuilder, propertyWidgetFactory);
    }

    protected AbstractComponentBuilderPanel(Image watermarkImage, int watermarkHorizontalPosition, int watermarkVerticalPosition, ComponentBuilder componentBuilder, PropertyWidgetFactory propertyWidgetFactory) {
        super(watermarkImage, watermarkHorizontalPosition, watermarkVerticalPosition, WidgetUtils.COLOR_WELL_BACKGROUND);
        this._taskPaneContainer.setLayout((LayoutManager)new VerticalLayout(4));
        this._componentBuilder = componentBuilder;
        this._descriptor = componentBuilder.getDescriptor();
        this._propertyWidgetFactory = propertyWidgetFactory;
        this._propertyWidgetCollection = propertyWidgetFactory.getPropertyWidgetCollection();
        this._outputDataStreamsViewer = new OutputDataStreamsViewer(this._componentBuilder);
        this.setLayout(new BorderLayout());
        JScrollPane scrolleable = WidgetUtils.scrolleable((JComponent)((Object)this._taskPaneContainer));
        this.add((Component)scrolleable, "Center");
        this._buttonPanel = this.createTopButtonPanel();
        this.add((Component)this._buttonPanel, "North");
    }

    public void addToButtonPanel(JComponent component) {
        this._buttonPanel.add(component);
    }

    protected JComponent createTopButtonPanel() {
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 0));
        return buttonPanel;
    }

    protected JXTaskPaneContainer getTaskPaneContainer() {
        return this._taskPaneContainer;
    }

    @Override
    public final JComponent createJComponent() {
        this.init();
        JComponent decorate = this.decorateMainPanel(this);
        return decorate;
    }

    @Override
    public ComponentBuilder getComponentBuilder() {
        return this._componentBuilder;
    }

    protected JComponent decorateMainPanel(DCPanel panel) {
        return panel;
    }

    private final void init() {
        ComponentBuilder componentBuilder = this.getComponentBuilder();
        List<ConfiguredPropertyTaskPane> propertyTaskPanes = this.createPropertyTaskPanes();
        HashSet unconfiguredPropertyDescriptors = new HashSet();
        unconfiguredPropertyDescriptors.addAll(componentBuilder.getDescriptor().getConfiguredProperties());
        for (ConfiguredPropertyTaskPane propertyTaskPane : propertyTaskPanes) {
            this.buildTaskPane(propertyTaskPane.getProperties(), this.imageManager.getImageIcon(propertyTaskPane.getIconImagePath(), 16, this.getClass().getClassLoader()), propertyTaskPane.getTitle(), componentBuilder, propertyTaskPane.isExpanded());
            unconfiguredPropertyDescriptors.removeAll(propertyTaskPane.getProperties());
        }
        if (!unconfiguredPropertyDescriptors.isEmpty()) {
            for (ConfiguredPropertyDescriptor property : unconfiguredPropertyDescriptors) {
                logger.warn("No property widget was found in task panes for property: {}", (Object)property);
                PropertyWidget<?> propertyWidget = this.createPropertyWidget(componentBuilder, property);
                this.getPropertyWidgetCollection().registerWidget(property, propertyWidget);
            }
        }
        this.onOutputDataStreamsChanged();
    }

    protected List<ConfiguredPropertyTaskPane> createPropertyTaskPanes() {
        TreeSet configuredProperties = new TreeSet(this._descriptor.getConfiguredProperties());
        ArrayList<ConfiguredPropertyDescriptor> inputProperties = new ArrayList<ConfiguredPropertyDescriptor>();
        ArrayList<ConfiguredPropertyDescriptor> requiredProperties = new ArrayList<ConfiguredPropertyDescriptor>();
        ArrayList<ConfiguredPropertyDescriptor> optionalProperties = new ArrayList<ConfiguredPropertyDescriptor>();
        for (ConfiguredPropertyDescriptor propertyDescriptor : configuredProperties) {
            boolean required = propertyDescriptor.isRequired();
            if (required && propertyDescriptor.isInputColumn()) {
                inputProperties.add(propertyDescriptor);
                continue;
            }
            if (required) {
                requiredProperties.add(propertyDescriptor);
                continue;
            }
            optionalProperties.add(propertyDescriptor);
        }
        ArrayList<ConfiguredPropertyTaskPane> result = new ArrayList<ConfiguredPropertyTaskPane>();
        result.add(new ConfiguredPropertyTaskPane("Input columns", "images/model/column.png", inputProperties));
        result.add(new ConfiguredPropertyTaskPane("Required properties", "images/menu/options.png", requiredProperties));
        result.add(new ConfiguredPropertyTaskPane("Optional properties (" + optionalProperties.size() + ")", "images/actions/edit.png", optionalProperties, false));
        return result;
    }

    protected void buildTaskPane(List<ConfiguredPropertyDescriptor> properties, Icon icon, String title, ComponentBuilder componentBuilder) {
        this.buildTaskPane(properties, icon, title, componentBuilder, true);
    }

    protected void buildTaskPane(List<ConfiguredPropertyDescriptor> properties, Icon icon, String title, ComponentBuilder componentBuilder, boolean expanded) {
        if (!properties.isEmpty()) {
            PropertyWidgetPanel panel = new PropertyWidgetPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                protected PropertyWidget<?> getPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor) {
                    PropertyWidget<?> propertyWidget = AbstractComponentBuilderPanel.this.createPropertyWidget(AbstractComponentBuilderPanel.this.getComponentBuilder(), propertyDescriptor);
                    AbstractComponentBuilderPanel.this.getPropertyWidgetCollection().registerWidget(propertyDescriptor, propertyWidget);
                    return propertyWidget;
                }
            };
            panel.addProperties(properties);
            if (!panel.isEmpty()) {
                this.addTaskPane(icon, title, (JComponent)panel, expanded);
            }
        }
    }

    protected PropertyWidget<?> createPropertyWidget(ComponentBuilder componentBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        return this.getPropertyWidgetFactory().create(propertyDescriptor);
    }

    protected JXTaskPane addTaskPane(String iconImagePath, String title, JComponent content) {
        return this.addTaskPane(iconImagePath, title, content, true);
    }

    protected JXTaskPane addTaskPane(String iconImagePath, String title, JComponent content, boolean expanded) {
        ImageIcon icon = this.imageManager.getImageIcon(iconImagePath, 16, new ClassLoader[0]);
        return this.addTaskPane(icon, title, content, expanded);
    }

    protected JXTaskPane addTaskPane(Icon icon, String title, JComponent content) {
        return this.addTaskPane(icon, title, content, true);
    }

    protected JXTaskPane addTaskPane(Icon icon, String title, JComponent content, boolean expanded) {
        JXTaskPane taskPane = WidgetFactory.createTaskPane(title, icon);
        taskPane.setCollapsed(!expanded);
        taskPane.add((Component)content);
        this._taskPaneContainer.add(taskPane);
        return taskPane;
    }

    @Override
    public final void applyPropertyValues() {
        this.applyPropertyValues(true);
    }

    public final void applyPropertyValues(boolean errorAware) {
        for (PropertyWidget<?> propertyWidget : this.getPropertyWidgetCollection().getWidgets()) {
            ConfiguredPropertyDescriptor propertyDescriptor = propertyWidget.getPropertyDescriptor();
            if (propertyWidget.isSet()) {
                Object value = propertyWidget.getValue();
                this.setConfiguredProperty(propertyDescriptor, value);
                continue;
            }
            if (!errorAware || !propertyDescriptor.isRequired()) continue;
            throw new UnconfiguredConfiguredPropertyException(this.getComponentBuilder(), propertyDescriptor);
        }
    }

    public final PropertyWidgetFactory getPropertyWidgetFactory() {
        return this._propertyWidgetFactory;
    }

    public PropertyWidgetCollection getPropertyWidgetCollection() {
        return this._propertyWidgetCollection;
    }

    public AnalysisJobBuilder getAnalysisJobBuilder() {
        return this.getComponentBuilder().getAnalysisJobBuilder();
    }

    protected void setConfiguredProperty(ConfiguredPropertyDescriptor propertyDescriptor, Object value) {
        this.getComponentBuilder().setConfiguredProperty(propertyDescriptor, value);
    }

    protected void onConfigurationChanged() {
        this.getPropertyWidgetCollection().onConfigurationChanged();
        this.onOutputDataStreamsChanged();
    }

    private void onOutputDataStreamsChanged() {
        this._taskPaneContainer.remove(this._outputDataStreamsTaskPane);
        this._outputDataStreamsViewer.refresh();
        if (this._outputDataStreamsViewer.isEnabled()) {
            this._outputDataStreamsTaskPane = this.addTaskPane("images/component-types/output-data-stream.png", "Output data streams", (JComponent)this._outputDataStreamsViewer);
            this._taskPaneContainer.updateUI();
        }
    }

    @Deprecated
    protected void onRequirementChanged() {
    }

    @Deprecated
    protected final boolean showContextVisualization() {
        return false;
    }
}

