/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.OutputColumnVisibilityButton;
import org.jdesktop.swingx.JXTextField;

public class MutableInputColumnListPanel
extends DCPanel
implements MutableInputColumn.Listener,
Closeable {
    private static final long serialVersionUID = 1L;
    private final MutableInputColumn<?> _inputColumn;
    private final JXTextField _textField;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final OutputColumnVisibilityButton _visibilityButton;
    private final JComponent panelOwner;

    public MutableInputColumnListPanel(AnalysisJobBuilder analysisJobBuilder, MutableInputColumn<?> inputColumn, JComponent panelOwner) {
        this._analysisJobBuilder = analysisJobBuilder;
        this._inputColumn = inputColumn;
        this.setLayout(new GridBagLayout());
        this._textField = WidgetFactory.createTextField("Column name");
        this._textField.setText(inputColumn.getName());
        this._textField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!MutableInputColumnListPanel.this._inputColumn.getName().equals(MutableInputColumnListPanel.this._textField.getText())) {
                    MutableInputColumnListPanel.this._inputColumn.setName(MutableInputColumnListPanel.this._textField.getText());
                    TransformerComponentBuilder tjb = MutableInputColumnListPanel.this._analysisJobBuilder.getOriginatingTransformer((InputColumn)MutableInputColumnListPanel.this._inputColumn);
                    if (tjb != null) {
                        tjb.onOutputChanged();
                    }
                }
            }
        });
        this._inputColumn.addListener((MutableInputColumn.Listener)this);
        this._visibilityButton = new OutputColumnVisibilityButton(inputColumn);
        JButton resetButton = WidgetFactory.createSmallButton("images/actions/reset.png");
        resetButton.setToolTipText("Reset output column name");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MutableInputColumnListPanel.this._textField.setText(MutableInputColumnListPanel.this._inputColumn.getInitialName());
            }
        });
        WidgetUtils.addToGridBag((Component)this._visibilityButton, (JPanel)this, 0, 0, 17, 0.0, 0.0);
        WidgetUtils.addToGridBag((Component)this._textField, (JPanel)this, 1, 0, 17, 1.0, 1.0);
        WidgetUtils.addToGridBag((Component)resetButton, (JPanel)this, 2, 0, 17, 0.0, 0.0);
        this.panelOwner = panelOwner;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    public void onNameChanged(MutableInputColumn<?> column, String oldName, String newName) {
        this._textField.setText(newName);
        if (this.panelOwner != null) {
            this.panelOwner.repaint();
        }
    }

    public void onVisibilityChanged(MutableInputColumn<?> column, boolean hidden) {
        this._visibilityButton.setSelected(!hidden);
    }

    @Override
    public void close() throws IOException {
        this._inputColumn.removeListener((MutableInputColumn.Listener)this);
    }
}

