/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.panels;

import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.apache.metamodel.schema.Column;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.data.MetaModelInputColumn;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.panels.ColumnListTable;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetUtils;
import org.jdesktop.swingx.VerticalLayout;

public final class OutputDataStreamsViewer
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final ComponentBuilder _componentBuilder;

    public OutputDataStreamsViewer(ComponentBuilder componentBuilder) {
        this._componentBuilder = componentBuilder;
        this.setLayout((LayoutManager)new VerticalLayout(4));
    }

    public void refresh() {
        this.removeAll();
        this.setEnabled(false);
        for (OutputDataStream outputDataStream : this._componentBuilder.getOutputDataStreams()) {
            this.setEnabled(true);
            ArrayList<MetaModelInputColumn> inputColumns = new ArrayList<MetaModelInputColumn>();
            for (Column column : outputDataStream.getTable().getColumns()) {
                inputColumns.add(new MetaModelInputColumn(column));
            }
            JLabel tableNameLabel = new JLabel(outputDataStream.getName(), ImageManager.get().getImageIcon("images/component-types/output-data-stream.png", 16, new ClassLoader[0]), 2);
            tableNameLabel.setOpaque(false);
            tableNameLabel.setFont(WidgetUtils.FONT_HEADER1);
            tableNameLabel.setBorder(new EmptyBorder(5, 5, 0, 5));
            ColumnListTable columnListTable = new ColumnListTable(inputColumns, this._componentBuilder.getAnalysisJobBuilder(), true, false, null);
            columnListTable.setBorder(new EmptyBorder(0, 5, 5, 5));
            this.add(tableNameLabel);
            this.add(columnListTable);
        }
    }
}

