/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.job.AnyComponentRequirement;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.AbstractComponentBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.LabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeRequirementMenuBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ChangeRequirementMenuBuilder.class);
    public static final String NO_REQUIREMENT_TEXT = "(No requirement)";
    public static final String ANY_REQUIREMENT_TEXT = "All records";
    private static final ImageManager imageManager = ImageManager.get();
    private static final Icon selectedRequirementIcon = imageManager.getImageIcon("images/status/valid.png", 16, new ClassLoader[0]);
    private static final Icon unconfiguredFilterIcon = imageManager.getImageIcon("images/status/warning.png", 16, new ClassLoader[0]);
    private final ComponentBuilder _componentBuilder;

    public ChangeRequirementMenuBuilder(ComponentBuilder componentBuilder) {
        this._componentBuilder = componentBuilder;
    }

    public List<JMenuItem> createMenuItems() {
        ComponentRequirement currentComponentRequirement = this._componentBuilder.getComponentRequirement();
        logger.info("Current requirement: {}", (Object)currentComponentRequirement);
        Collection<Object> currentFilterOutcomes = currentComponentRequirement == null ? Collections.emptyList() : currentComponentRequirement.getProcessingDependencies();
        ArrayList<JMenuItem> popup = new ArrayList<JMenuItem>();
        JMenuItem noFilterMenuItem = new JMenuItem(NO_REQUIREMENT_TEXT);
        noFilterMenuItem.setToolTipText("Do not apply any specific requirements on this component, except for those that are transitively inherited by the configuration.");
        noFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeRequirementMenuBuilder.this._componentBuilder.setComponentRequirement(null);
                ChangeRequirementMenuBuilder.this.onRequirementChanged();
            }
        });
        popup.add(noFilterMenuItem);
        JMenuItem anyFilterMenuItem = new JMenuItem(ANY_REQUIREMENT_TEXT);
        anyFilterMenuItem.setToolTipText("Explicitly accept all records into this component, regardless of any other transitive requirements.");
        anyFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeRequirementMenuBuilder.this._componentBuilder.setComponentRequirement(AnyComponentRequirement.get());
                ChangeRequirementMenuBuilder.this.onRequirementChanged();
            }
        });
        if (AnyComponentRequirement.get().equals(this._componentBuilder.getComponentRequirement())) {
            anyFilterMenuItem.setIcon(selectedRequirementIcon);
        }
        popup.add(anyFilterMenuItem);
        List<FilterComponentBuilder<?, ?>> fjbs = this.getFilterJobBuilders();
        for (final FilterComponentBuilder<?, ?> fjb : fjbs) {
            JMenu filterMenuItem = new JMenu(LabelUtils.getLabel(fjb));
            if (!fjb.isConfigured()) {
                filterMenuItem.setIcon(unconfiguredFilterIcon);
                filterMenuItem.setEnabled(false);
                filterMenuItem.setToolTipText("Filter is not correctly configured");
            } else if (!this.validateRequirementSource(fjb)) {
                filterMenuItem.setEnabled(false);
                filterMenuItem.setToolTipText("Requirement not possible");
            } else {
                FilterDescriptor fjbDescriptor = (FilterDescriptor)fjb.getDescriptor();
                Set categoryNames = fjbDescriptor.getOutcomeCategoryNames();
                for (final String category : categoryNames) {
                    JMenuItem categoryMenuItem = new JMenuItem(category);
                    try {
                        Enum outcomeCategory = fjbDescriptor.getOutcomeCategoryByName(category);
                        FilterOutcome filterOutcome = fjb.getFilterOutcome((Object)outcomeCategory);
                        if (currentFilterOutcomes.contains(filterOutcome)) {
                            filterMenuItem.setIcon(selectedRequirementIcon);
                            categoryMenuItem.setIcon(selectedRequirementIcon);
                        }
                    }
                    catch (Exception ex) {
                        logger.info("Filterjob matching threw exception, probably because of incomplete configuration", (Throwable)ex);
                    }
                    categoryMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Enum outcome = ((FilterDescriptor)fjb.getDescriptor()).getOutcomeCategoryByName(category);
                            FilterOutcome filterOutcome = fjb.getFilterOutcome((Object)outcome);
                            SimpleComponentRequirement newRequirement = new SimpleComponentRequirement(filterOutcome);
                            ChangeRequirementMenuBuilder.this._componentBuilder.setComponentRequirement((ComponentRequirement)newRequirement);
                            ChangeRequirementMenuBuilder.this.onRequirementChanged();
                        }
                    });
                    filterMenuItem.add(categoryMenuItem);
                }
            }
            popup.add(filterMenuItem);
        }
        return popup;
    }

    private List<FilterComponentBuilder<?, ?>> getFilterJobBuilders() {
        LinkedList fjbs;
        if (this._componentBuilder instanceof FilterComponentBuilder) {
            fjbs = new LinkedList(this._componentBuilder.getAnalysisJobBuilder().getFilterComponentBuilders());
            fjbs.remove(this._componentBuilder);
        } else {
            fjbs = this._componentBuilder.getAnalysisJobBuilder().getFilterComponentBuilders();
        }
        return fjbs;
    }

    private boolean validateRequirementSource(FilterComponentBuilder<?, ?> fjb) {
        if (this._componentBuilder instanceof AbstractComponentBuilder) {
            AbstractComponentBuilder abstractBeanWithInputColumnsBuilder = (AbstractComponentBuilder)this._componentBuilder;
            return abstractBeanWithInputColumnsBuilder.validateRequirementSource(fjb);
        }
        return true;
    }

    protected void onRequirementChanged() {
    }

    public boolean isFilterRequirementsAvailable() {
        return !this.getFilterJobBuilders().isEmpty();
    }
}

