/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.WidgetUtils;

public class DCCheckBox<E>
extends JCheckBox
implements MouseListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final Border HOVER_BORDER = new LineBorder(WidgetUtils.BG_COLOR_LESS_BRIGHT, 1);
    private static final Border REGULAR_BORDER = new EmptyBorder(1, 1, 1, 1);
    private final List<Listener<E>> _listeners = new ArrayList<Listener<E>>();
    private E _value;
    private volatile Border _previousBorder;

    public DCCheckBox(String text, boolean selected) {
        super(text, selected);
        if (!StringUtils.isNullOrEmpty((String)text)) {
            this.setBorder(REGULAR_BORDER);
            this.setBorderPainted(true);
            this.addMouseListener(this);
        }
        super.addItemListener(this);
    }

    public E getValue() {
        return this._value;
    }

    public void setValue(E value) {
        this._value = value;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.notifyListeners();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this._previousBorder == null) {
            this._previousBorder = this.getBorder();
        }
        this.setBorder(HOVER_BORDER);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setBorder(this._previousBorder);
        this._previousBorder = null;
    }

    public void addListenerToHead(Listener<E> listener) {
        this._listeners.add(0, listener);
    }

    public void addListener(Listener<E> listener) {
        this._listeners.add(listener);
    }

    public void removeListener(Listener<E> listener) {
        this._listeners.remove(listener);
    }

    @Override
    @Deprecated
    public void addItemListener(ItemListener aListener) {
        super.addItemListener(aListener);
    }

    @Override
    @Deprecated
    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
    }

    public void notifyListeners() {
        this.notifyListeners(this.getValue(), this.isSelected());
    }

    private void notifyListeners(E item, boolean selected) {
        for (Listener<E> listener : this._listeners) {
            listener.onItemSelected(item, selected);
        }
    }

    public void setSelected(boolean selected, boolean notifyListeners) {
        boolean previous = this.isSelected();
        if (selected == previous) {
            return;
        }
        this.setSelected(selected);
        this.notifyListeners();
    }

    @Override
    public String toString() {
        return "DCCheckBox[value=" + this._value + ", selected=" + this.isSelected() + "]";
    }

    public static interface Listener<E> {
        public void onItemSelected(E var1, boolean var2);
    }
}

