/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.LookAndFeelManager;

public class PopupButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private MenuPosition menuPosition;

    public PopupButton(String text) {
        this(text, null);
    }

    public PopupButton(String text, Icon icon) {
        this(text, icon, MenuPosition.BOTTOM);
    }

    public PopupButton(String text, Icon icon, MenuPosition position) {
        super(text, icon);
        this.menuPosition = position;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PopupButton.this.isSelected()) {
                    PopupButton.this.showPopup(PopupButton.this.popupMenu);
                }
            }
        });
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent pme) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
                if (UIManager.getBoolean("PopupMenu.consumeEventOnClose")) {
                    PopupButton.this.setSelected(false);
                } else {
                    Point mouseLoc = MouseInfo.getPointerInfo().getLocation();
                    Point componentLoc = PopupButton.this.getLocationOnScreen();
                    mouseLoc.x -= componentLoc.x;
                    mouseLoc.y -= componentLoc.y;
                    if (!PopupButton.this.contains(mouseLoc)) {
                        PopupButton.this.setSelected(false);
                    }
                }
            }
        });
    }

    public void setMenuPosition(MenuPosition menuPosition) {
        this.menuPosition = menuPosition;
    }

    public MenuPosition getMenuPosition() {
        return this.menuPosition;
    }

    protected void showPopup(JPopupMenu menu) {
        int y;
        int x;
        if (this.menuPosition == null) {
            this.menuPosition = MenuPosition.BOTTOM;
        }
        switch (this.menuPosition) {
            case BOTTOM: {
                x = 0;
                y = this.getHeight();
                break;
            }
            case TOP: {
                menu.show(this, 0, 0);
                x = 0;
                y = menu.getHeight() * -1;
                break;
            }
            case LEFT: {
                x = menu.getWidth() * -1;
                y = 0;
                break;
            }
            case RIGHT: {
                x = this.getWidth();
                y = 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported position: " + (Object)((Object)this.menuPosition));
            }
        }
        menu.show(this, x, y);
    }

    public JPopupMenu getMenu() {
        return this.popupMenu;
    }

    public static void main(String[] args) {
        LookAndFeelManager.get().init();
        PopupButton popupButton = new PopupButton("More", ImageManager.get().getImageIcon("images/menu/more.png", new ClassLoader[0]));
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.add(popupButton);
        JToolBar toolBar = new JToolBar();
        toolBar.add(toolBarPanel);
        JPanel popupPanel = new JPanel();
        popupPanel.setLayout(new BorderLayout());
        popupPanel.add((Component)new JLabel("This popup has components"), "North");
        popupPanel.add((Component)new JTextArea("Some text", 15, 20), "Center");
        popupPanel.add((Component)new JSlider(), "South");
        popupButton.getMenu().add(popupPanel);
        JFrame frame = new JFrame("test");
        frame.setDefaultCloseOperation(3);
        frame.setPreferredSize(new Dimension(640, 480));
        frame.add((Component)toolBar, "First");
        frame.pack();
        frame.setVisible(true);
    }

    public static enum MenuPosition {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

