/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.metamodel.util.EqualsBuilder;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.widgets.properties.PropertyWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinimalPropertyWidget<E>
implements PropertyWidget<E> {
    private static final Logger logger = LoggerFactory.getLogger(MinimalPropertyWidget.class);
    private final ComponentBuilder _componentBuilder;
    private final ConfiguredPropertyDescriptor _propertyDescriptor;
    private transient int _updating;

    public MinimalPropertyWidget(ComponentBuilder componentBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        this._componentBuilder = componentBuilder;
        this._propertyDescriptor = propertyDescriptor;
        this._updating = 0;
    }

    @Override
    public void initialize(E value) {
    }

    @Override
    public final ConfiguredPropertyDescriptor getPropertyDescriptor() {
        return this._propertyDescriptor;
    }

    public final ComponentBuilder getComponentBuilder() {
        return this._componentBuilder;
    }

    @Override
    public boolean isSet() {
        return this.getValue() != null;
    }

    public final void fireValueChanged() {
        Object value = this.getValue();
        this.fireValueChanged(value);
    }

    protected ActionListener fireValueChangedActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MinimalPropertyWidget.this.fireValueChanged();
            }
        };
    }

    protected final AnalysisJobBuilder getAnalysisJobBuilder() {
        return this.getComponentBuilder().getAnalysisJobBuilder();
    }

    @Override
    public void onValueTouched(E value) {
        if (this.isUpdating()) {
            return;
        }
        Object existingValue = this.getValue();
        if (EqualsBuilder.equals(value, existingValue)) {
            return;
        }
        this.setValue(value);
    }

    protected boolean isUpdating() {
        return this._updating > 0;
    }

    protected void setUpdating(boolean updating) {
        if (updating) {
            ++this._updating;
        } else {
            assert (this._updating > 0);
            --this._updating;
        }
    }

    protected E getCurrentValue() {
        return (E)this.getComponentBuilder().getConfiguredProperty(this.getPropertyDescriptor());
    }

    protected abstract void setValue(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireValueChanged(Object newValue) {
        this.setUpdating(true);
        try {
            this._componentBuilder.setConfiguredProperty(this._propertyDescriptor, newValue);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception when setting property: " + this._propertyDescriptor + ": " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.setUpdating(false);
        }
    }
}

