/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.table;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.ArrayUtils;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.Alignment;
import org.datacleaner.widgets.table.DCTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCTableCellRenderer
implements TableCellRenderer {
    private static final Logger logger = LoggerFactory.getLogger(DCTableCellRenderer.class);
    private final DCTable _table;
    private final Map<Integer, Alignment> _alignmentOverrides;
    private final DefaultTableCellRenderer _delegate;

    public DCTableCellRenderer(DCTable table) {
        this._table = table;
        this._alignmentOverrides = new HashMap<Integer, Alignment>();
        this._delegate = new DefaultTableCellRenderer();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result;
        logger.debug("getTableCellRendererComponent({},{})", (Object)row, (Object)column);
        if (value != null && value.getClass().isArray()) {
            value = ArrayUtils.toString((Object)value);
        }
        if (value instanceof Icon) {
            JLabel label = new JLabel((Icon)value);
            label.setOpaque(true);
            value = label;
        }
        if (value instanceof JComponent) {
            final JComponent component = (JComponent)value;
            component.setOpaque(true);
            if (component.getMouseListeners().length == 0) {
                component.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        MouseEvent newEvent = SwingUtilities.convertMouseEvent(component, e, (Component)((Object)DCTableCellRenderer.this._table));
                        DCTableCellRenderer.this._table.consumeMouseClick(newEvent);
                    }
                });
            }
            result = component;
        } else {
            result = this._delegate.getTableCellRendererComponent((JTable)((Object)this._table), value, isSelected, hasFocus, row, column);
            assert (result instanceof JLabel);
        }
        Alignment alignment = this._alignmentOverrides.get(column);
        if (alignment == null) {
            alignment = Alignment.LEFT;
        }
        if (value instanceof JPanel) {
            LayoutManager layout = ((JPanel)value).getLayout();
            if (layout instanceof FlowLayout) {
                FlowLayout flowLayout = (FlowLayout)layout;
                flowLayout.setAlignment(alignment.getFlowLayoutAlignment());
            }
        } else if (result instanceof JLabel) {
            JLabel label = (JLabel)result;
            label.setHorizontalAlignment(alignment.getSwingContstantsAlignment());
            WidgetUtils.setAppropriateFont(label);
        }
        return result;
    }

    public void setAlignment(int column, Alignment alignment) {
        this._alignmentOverrides.put(column, alignment);
    }
}

