/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.visualization;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.LabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentScopeMenuBuilder {
    public static final String DEFAULT_SCOPE_TEXT = "Default scope";
    private static final Logger logger = LoggerFactory.getLogger(ComponentScopeMenuBuilder.class);
    private static final ImageManager imageManager = ImageManager.get();
    private static final Icon selectedScopeIcon = imageManager.getImageIcon("images/status/valid.png", 16, new ClassLoader[0]);
    private final ComponentBuilder _componentBuilder;
    private final AnalysisJobBuilder _rootJobBuilder;

    public ComponentScopeMenuBuilder(ComponentBuilder componentBuilder) {
        this._componentBuilder = componentBuilder;
        this._rootJobBuilder = this._componentBuilder.getAnalysisJobBuilder().getRootJobBuilder();
    }

    public List<ComponentBuilder> getComponentBuildersWithOutputDataStreams(AnalysisJobBuilder jobBuilder) {
        ArrayList<ComponentBuilder> descendants = new ArrayList<ComponentBuilder>();
        for (ComponentBuilder child : jobBuilder.getComponentBuilders()) {
            if (child == this._componentBuilder || child.getOutputDataStreams().size() <= 0) continue;
            descendants.add(child);
            for (OutputDataStream outputDataStream : child.getOutputDataStreams()) {
                descendants.addAll(this.getComponentBuildersWithOutputDataStreams(child.getOutputDataStreamJobBuilder(outputDataStream)));
            }
        }
        return descendants;
    }

    public ComponentBuilder findComponentBuilder(AnalysisJobBuilder analysisJobBuilder) {
        if (analysisJobBuilder == this._rootJobBuilder) {
            return null;
        }
        for (ComponentBuilder osComponenBuilder : this.getComponentBuildersWithOutputDataStreams(this._rootJobBuilder)) {
            for (OutputDataStream outputDataStream : osComponenBuilder.getOutputDataStreams()) {
                AnalysisJobBuilder osJobBuilder = osComponenBuilder.getOutputDataStreamJobBuilder(outputDataStream);
                if (osJobBuilder != analysisJobBuilder) continue;
                return osComponenBuilder;
            }
        }
        throw new IllegalArgumentException("No builder holding that osJobBuilder");
    }

    public List<JMenuItem> createMenuItems() {
        ComponentRequirement currentComponentRequirement = this._componentBuilder.getComponentRequirement();
        logger.info("Current requirement: {}", (Object)currentComponentRequirement);
        ArrayList<JMenuItem> popup = new ArrayList<JMenuItem>();
        JMenuItem rootMenuItem = new JMenuItem(DEFAULT_SCOPE_TEXT);
        rootMenuItem.setToolTipText("Use the default scope for this component");
        rootMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentScopeMenuBuilder.this.onScopeChangeStart();
                ComponentScopeMenuBuilder.this._rootJobBuilder.moveComponent(ComponentScopeMenuBuilder.this._componentBuilder);
                ComponentScopeMenuBuilder.this._componentBuilder.setComponentRequirement(null);
                ComponentScopeMenuBuilder.this.onScopeChangeComplete(ComponentScopeMenuBuilder.this._rootJobBuilder, null);
            }
        });
        if (this._rootJobBuilder == this._componentBuilder.getAnalysisJobBuilder()) {
            rootMenuItem.setIcon(selectedScopeIcon);
        }
        popup.add(rootMenuItem);
        List<ComponentBuilder> osComponentBuilders = this.getComponentBuildersWithOutputDataStreams(this._rootJobBuilder);
        for (final ComponentBuilder osComponentBuilder : osComponentBuilders) {
            JMenu componentMenu = new JMenu(LabelUtils.getLabel((ComponentBuilder)osComponentBuilder));
            for (OutputDataStream outputDataStream : osComponentBuilder.getOutputDataStreams()) {
                final AnalysisJobBuilder osJobBuilder = osComponentBuilder.getOutputDataStreamJobBuilder(outputDataStream);
                JMenuItem scopeMenuItem = new JMenuItem(osJobBuilder.getDatastore().getName());
                if (osJobBuilder == this._componentBuilder.getAnalysisJobBuilder()) {
                    componentMenu.setIcon(selectedScopeIcon);
                    scopeMenuItem.setIcon(selectedScopeIcon);
                }
                scopeMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ComponentScopeMenuBuilder.this.onScopeChangeStart();
                        osJobBuilder.moveComponent(ComponentScopeMenuBuilder.this._componentBuilder);
                        ComponentScopeMenuBuilder.this._componentBuilder.setComponentRequirement(null);
                        ComponentScopeMenuBuilder.this.onScopeChangeComplete(osJobBuilder, osComponentBuilder);
                    }
                });
                componentMenu.add(scopeMenuItem);
            }
            popup.add(componentMenu);
        }
        return popup;
    }

    protected void onScopeChangeStart() {
    }

    protected void onScopeChangeComplete(AnalysisJobBuilder analysisJobBuilder, ComponentBuilder componentBuilder) {
    }
}

