/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.components.categories.WriteSuperCategory;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.widgets.DescriptorMenuItem;

public class DisplayOutputWritersAction {
    private final AnalysisJobBuilder _analysisJobBuilder;

    public DisplayOutputWritersAction(AnalysisJobBuilder analysisJobBuilder) {
        this._analysisJobBuilder = analysisJobBuilder;
    }

    public final void showPopup(JComponent component) {
        JPopupMenu popup = new JPopupMenu();
        List<JMenuItem> menuItems = this.createMenuItems();
        for (JMenuItem menuItem : menuItems) {
            popup.add(menuItem);
        }
        popup.show(component, 0, component.getHeight());
    }

    public List<JMenuItem> createMenuItems() {
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        for (final ComponentDescriptor<?> descriptor : this.getDescriptors()) {
            DescriptorMenuItem outputWriterMenuItem = new DescriptorMenuItem(this._analysisJobBuilder, null, descriptor, false);
            outputWriterMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComponentBuilder componentBuilder = DisplayOutputWritersAction.this._analysisJobBuilder.addComponent(descriptor);
                    DisplayOutputWritersAction.this.configure(DisplayOutputWritersAction.this._analysisJobBuilder, componentBuilder);
                }
            });
            result.add(outputWriterMenuItem);
        }
        return result;
    }

    protected void configure(AnalysisJobBuilder analysisJobBuilder, ComponentBuilder componentBuilder) {
    }

    protected Collection<? extends ComponentDescriptor<?>> getDescriptors() {
        DescriptorProvider descriptorProvider = this._analysisJobBuilder.getConfiguration().getEnvironment().getDescriptorProvider();
        Collection descriptors = descriptorProvider.getComponentDescriptorsOfSuperCategory((ComponentSuperCategory)new WriteSuperCategory());
        return descriptors;
    }
}

