/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.AnalyzerComponentBuilder;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.AnalysisRunnerImpl;
import org.datacleaner.panels.TransformerComponentBuilderPresenter;
import org.datacleaner.util.PreviewTransformedDataAnalyzer;
import org.datacleaner.util.PreviewUtils;
import org.datacleaner.util.SourceColumnFinder;
import org.datacleaner.windows.DataSetWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreviewTransformedDataActionListener
implements ActionListener,
Callable<TableModel> {
    private static final Logger logger = LoggerFactory.getLogger(PreviewTransformedDataActionListener.class);
    public static final int DEFAULT_PREVIEW_ROWS = 200;
    private final TransformerComponentBuilderPresenter _transformerJobBuilderPresenter;
    private final TransformerComponentBuilder<?> _transformerJobBuilder;
    private final WindowContext _windowContext;
    private final int _previewRows;
    private DataSetWindow _latestWindow;

    public PreviewTransformedDataActionListener(WindowContext windowContext, TransformerComponentBuilder<?> transformerJobBuilder) {
        this(windowContext, null, transformerJobBuilder);
    }

    public PreviewTransformedDataActionListener(WindowContext windowContext, TransformerComponentBuilderPresenter transformerJobBuilderPresenter, TransformerComponentBuilder<?> transformerJobBuilder) {
        this(windowContext, transformerJobBuilderPresenter, transformerJobBuilder, 200);
    }

    public PreviewTransformedDataActionListener(WindowContext windowContext, TransformerComponentBuilderPresenter transformerJobBuilderPresenter, TransformerComponentBuilder<?> transformerJobBuilder, int previewRows) {
        this._windowContext = windowContext;
        this._transformerJobBuilderPresenter = transformerJobBuilderPresenter;
        this._transformerJobBuilder = transformerJobBuilder;
        this._previewRows = previewRows;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSetWindow existingWindow = this._latestWindow;
        if (existingWindow != null) {
            existingWindow.close();
            this._latestWindow = null;
        }
        DataSetWindow window = new DataSetWindow("Preview of transformed dataset", this, this._windowContext);
        window.open();
        this._latestWindow = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreviewJob createPreviewJob() {
        AnalysisJobBuilder ajb;
        if (this._transformerJobBuilderPresenter != null) {
            this._transformerJobBuilderPresenter.applyPropertyValues();
        }
        String jobBuilderIdentifier = UUID.randomUUID().toString();
        AnalysisJobBuilder originalAnalysisJobBuilder = this._transformerJobBuilder.getAnalysisJobBuilder();
        originalAnalysisJobBuilder.getAnalysisJobMetadata().getProperties().put("org.datacleaner.preview.targetcomponent", jobBuilderIdentifier);
        try {
            AnalysisJobBuilder copyAnalysisJobBuilder = PreviewUtils.copy((AnalysisJobBuilder)originalAnalysisJobBuilder.getRootJobBuilder());
            ajb = PreviewUtils.findAnalysisJobBuilder((AnalysisJobBuilder)copyAnalysisJobBuilder, (String)jobBuilderIdentifier);
        }
        finally {
            originalAnalysisJobBuilder.getAnalysisJobMetadata().getProperties().remove("org.datacleaner.preview.targetcomponent");
        }
        if (ajb == null) {
            throw new IllegalStateException("Could not find AnalysisJobBuilder copy which is equivalent to the original");
        }
        TransformerComponentBuilder<?> tjb = this.findTransformerComponentBuilder(ajb);
        PreviewUtils.sanitizeIrrelevantComponents((AnalysisJobBuilder)ajb, tjb);
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(ajb);
        List tables = ajb.getSourceTables();
        if (tables.size() > 1) {
            Table originatingTable = sourceColumnFinder.findOriginatingTable((InputColumn)tjb.getOutputColumns().get(0));
            tables.remove(originatingTable);
            for (Table otherTable : tables) {
                ajb.removeSourceTable(otherTable);
            }
        }
        boolean alreadyFiltered = sourceColumnFinder.findAllSourceJobs(tjb).stream().filter(o -> o instanceof HasFilterOutcomes).findAny().isPresent();
        List sourceColumns = ajb.getSourceColumns();
        if (sourceColumns.isEmpty()) {
            logger.error("No source columns left after removing irrelevant source tables. Component: {}", this._transformerJobBuilder);
            return null;
        }
        AnalyzerComponentBuilder rowCollector = (AnalyzerComponentBuilder)((AnalyzerComponentBuilder)ajb.addAnalyzer(Descriptors.ofAnalyzer(PreviewTransformedDataAnalyzer.class)).addInputColumns((Collection)tjb.getInputColumns())).addInputColumns((Collection)tjb.getOutputColumns());
        if (tjb.getComponentRequirement() != null) {
            rowCollector.setComponentRequirement(tjb.getComponentRequirement());
        }
        AnalysisJobBuilder rootJobBuilder = ajb.getRootJobBuilder();
        Collection componentBuilders = alreadyFiltered ? rootJobBuilder.getFilterComponentBuilders() : rootJobBuilder.getComponentBuilders();
        PreviewUtils.limitJobRows((AnalysisJobBuilder)rootJobBuilder, (Collection)componentBuilders, (int)this._previewRows);
        return new PreviewJob(rootJobBuilder, rowCollector, tjb);
    }

    @Override
    public TableModel call() throws Exception {
        PreviewJob previewJob = this.createPreviewJob();
        if (previewJob == null) {
            return new DefaultTableModel(0, 0);
        }
        AnalyzerComponentBuilder<?> rowCollector = previewJob.rowCollectorAnalyzer;
        Object[] columnNames = new String[rowCollector.getInputColumns().size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = ((InputColumn)rowCollector.getInputColumns().get(i)).getName();
        }
        AnalysisRunnerImpl runner = new AnalysisRunnerImpl(previewJob.analysisJobBuilder.getConfiguration());
        AnalysisResultFuture resultFuture = runner.run(previewJob.analysisJobBuilder.toAnalysisJob());
        resultFuture.await();
        if (resultFuture.isErrornous()) {
            List errors = resultFuture.getErrors();
            Throwable firstError = (Throwable)errors.get(0);
            logger.error("Error occurred while running preview data job: {}", (Object)firstError.getMessage());
            for (Throwable throwable : errors) {
                logger.info("Preview data error", throwable);
            }
            if (firstError instanceof Exception) {
                throw (Exception)firstError;
            }
            throw new IllegalStateException(firstError);
        }
        List results = resultFuture.getResults(PreviewTransformedDataAnalyzer.class);
        assert (results.size() == 1);
        PreviewTransformedDataAnalyzer result = (PreviewTransformedDataAnalyzer)results.get(0);
        List rows = result.getList();
        DefaultTableModel tableModel = new DefaultTableModel(columnNames, rows.size());
        int rowIndex = 0;
        for (Object[] row : rows) {
            if (row != null) {
                for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                    tableModel.setValueAt(row[columnIndex], rowIndex, columnIndex);
                }
            }
            ++rowIndex;
        }
        return tableModel;
    }

    private TransformerComponentBuilder<?> findTransformerComponentBuilder(AnalysisJobBuilder ajb) {
        AnalysisJobBuilder analysisJobBuilder = this._transformerJobBuilder.getAnalysisJobBuilder();
        int transformerIndex = analysisJobBuilder.getTransformerComponentBuilders().indexOf(this._transformerJobBuilder);
        return (TransformerComponentBuilder)ajb.getTransformerComponentBuilders().get(transformerIndex);
    }

    public static class PreviewJob {
        public final AnalysisJobBuilder analysisJobBuilder;
        public final AnalyzerComponentBuilder<?> rowCollectorAnalyzer;
        public final TransformerComponentBuilder<?> previewedTransformer;

        public PreviewJob(AnalysisJobBuilder analysisJobBuilder, AnalyzerComponentBuilder<?> rowCollectorAnalyzer, TransformerComponentBuilder<?> previewedTransformer) {
            this.analysisJobBuilder = analysisJobBuilder;
            this.rowCollectorAnalyzer = rowCollectorAnalyzer;
            this.previewedTransformer = previewedTransformer;
        }
    }
}

