/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.metamodel.schema.Column;
import org.datacleaner.api.ComponentCategory;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.InputColumn;
import org.datacleaner.components.categories.WriteDataCategory;
import org.datacleaner.configuration.RemoteServerState;
import org.datacleaner.connection.AccessDatastore;
import org.datacleaner.connection.CassandraDatastore;
import org.datacleaner.connection.CompositeDatastore;
import org.datacleaner.connection.CouchDbDatastore;
import org.datacleaner.connection.CsvDatastore;
import org.datacleaner.connection.DataHubDatastore;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DbaseDatastore;
import org.datacleaner.connection.ElasticSearchDatastore;
import org.datacleaner.connection.ExcelDatastore;
import org.datacleaner.connection.FixedWidthDatastore;
import org.datacleaner.connection.HBaseDatastore;
import org.datacleaner.connection.JdbcDatastore;
import org.datacleaner.connection.JsonDatastore;
import org.datacleaner.connection.MongoDbDatastore;
import org.datacleaner.connection.Neo4jDatastore;
import org.datacleaner.connection.OdbDatastore;
import org.datacleaner.connection.SalesforceDatastore;
import org.datacleaner.connection.SasDatastore;
import org.datacleaner.connection.SugarCrmDatastore;
import org.datacleaner.connection.XmlDatastore;
import org.datacleaner.database.DatabaseDriverCatalog;
import org.datacleaner.database.DatabaseDriverDescriptor;
import org.datacleaner.descriptors.Allowable;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.descriptors.HasIcon;
import org.datacleaner.descriptors.RemoteTransformerDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.ResourceManager;
import org.datacleaner.util.StringUtils;

public final class IconUtils {
    public static final int ICON_SIZE_LARGE = 32;
    public static final int ICON_SIZE_MEDIUM = 22;
    public static final int ICON_SIZE_SMALL = 16;
    public static final int ICON_SIZE_MENU_ITEM = 16;
    public static final int ICON_SIZE_BUTTON = 22;
    public static final int ICON_SIZE_TAB = 22;
    public static final int ICON_SIZE_TASK_PANE = 16;
    private static final ImageIcon ICON_TRANSPARENT_SMALL = IconUtils.createTransparentIcon(16);
    private static final ImageIcon ICON_TRANSPARENT_MEDIUM = IconUtils.createTransparentIcon(22);
    private static final ImageIcon ICON_TRANSPARENT_LARGE = IconUtils.createTransparentIcon(32);
    public static final String TRANSFORMER_IMAGEPATH = "images/component-types/transformer.png";
    public static final String ANALYZER_IMAGEPATH = "images/component-types/analyzer.png";
    public static final String FILTER_IMAGEPATH = "images/component-types/filter.png";
    public static final String FILTER_OUTCOME_PATH = "images/component-types/filter-outcome.png";
    public static final String OUTPUT_DATA_STREAM_PATH = "images/component-types/output-data-stream.png";
    public static final String MODEL_SCHEMA = "images/model/schema.png";
    public static final String MODEL_SCHEMA_INFORMATION = "images/model/schema_information.png";
    public static final String MODEL_TABLE = "images/model/table.png";
    public static final String MODEL_COLUMN = "images/model/column.png";
    public static final String MODEL_COLUMN_KEY = "images/model/column_primary_key.png";
    public static final String MODEL_COLUMN_EXPRESSION = "images/model/column_expression.png";
    public static final String MODEL_QUERY = "images/model/query.png";
    public static final String MODEL_ROW = "images/model/row.png";
    public static final String MODEL_JOB = "images/model/job.png";
    public static final String MODEL_RESULT = "images/model/result.png";
    public static final String MODEL_SOURCE = "images/model/source.png";
    public static final String MODEL_METADATA = "images/model/metadata.png";
    public static final String MODEL_QUICK_ANALYSIS = "images/component-types/analyzer.png";
    public static final String MODEL_COMPONENT_LIBRARY = "images/model/component_library.png";
    public static final String MENU_OPEN = "images/menu/open.png";
    public static final String MENU_NEW = "images/menu/new.png";
    public static final String MENU_EXECUTE = "images/menu/execute.png";
    public static final String MENU_REFRESH = "images/menu/refresh.png";
    public static final String MENU_OPTIONS = "images/menu/options.png";
    public static final String MENU_DQ_MONITOR = "images/menu/dq_monitor.png";
    public static final String MENU_DATACLOUD = "images/menu/datacloud.png";
    public static final String MENU_DOCUMENTATION = "images/menu/documentation.png";
    public static final String ACTION_EXECUTE = "images/menu/execute.png";
    public static final String ACTION_EDIT = "images/actions/edit.png";
    public static final String ACTION_SAVE_BRIGHT = "images/actions/save_bright.png";
    public static final String ACTION_SAVE_DARK = "images/actions/save_dark.png";
    @Deprecated
    public static final String ACTION_SAVE = "images/actions/save_dark.png";
    public static final String ACTION_CLOSE_BRIGHT = "images/actions/close_bright.png";
    public static final String ACTION_CLOSE_DARK = "images/actions/close_dark.png";
    public static final String ACTION_COPY = "images/actions/copy.png";
    public static final String ACTION_CANCEL = "images/actions/cancel.png";
    public static final String ACTION_ADD_DARK = "images/actions/add_dark.png";
    public static final String ACTION_REMOVE_DARK = "images/actions/remove_dark.png";
    public static final String ACTION_ADD_BRIGHT = "images/actions/add_bright.png";
    public static final String ACTION_REMOVE_BRIGHT = "images/actions/remove_bright.png";
    @Deprecated
    public static final String ACTION_ADD = "images/actions/add_dark.png";
    @Deprecated
    public static final String ACTION_REMOVE = "images/actions/remove_dark.png";
    public static final String ACTION_RESET = "images/actions/reset.png";
    public static final String ACTION_RENAME = "images/actions/rename.png";
    public static final String ACTION_REFRESH = "images/actions/refresh.png";
    public static final String ACTION_PREVIEW = "images/actions/preview_data.png";
    public static final String ACTION_BROWSE = "images/actions/browse.png";
    public static final String ACTION_HELP = "images/actions/help.png";
    public static final String ACTION_BACK = "images/actions/back.png";
    public static final String ACTION_FORWARD = "images/actions/forward.png";
    public static final String ACTION_SCROLLDOWN_DARK = "images/actions/scrolldown_dark.png";
    public static final String ACTION_SCROLLDOWN_BRIGHT = "images/actions/scrolldown_bright.png";
    public static final String ACTION_STOP = "images/actions/stop.png";
    public static final String ACTION_LOG = "images/actions/log.png";
    public static final String ACTION_DRILL_TO_DETAIL = "images/actions/drill-to-detail.png";
    public static final String ACTION_DOWNLOAD = "images/actions/download.png";
    public static final String ACTION_DELETE = "images/actions/delete.png";
    public static final String ACTION_DROP_TABLE = "images/actions/drop_table.png";
    public static final String ACTION_CREATE_TABLE = "images/actions/create_table.png";
    public static final String APPLICATION_ICON = "images/window/app-icon.png";
    public static final String WEBSITE = "images/actions/website.png";
    public static final String PLUGIN = "images/component-types/plugin.png";
    public static final String STATUS_VALID = "images/status/valid.png";
    public static final String STATUS_INFO = "images/status/info.png";
    public static final String STATUS_WARNING = "images/status/warning.png";
    public static final String STATUS_ERROR = "images/status/error.png";
    public static final String ACTION_REORDER_COLUMNS = "images/actions/reorder-columns.png";
    public static final String CHART_BAR = "images/chart-types/bar.png";
    public static final String CHART_LINE = "images/chart-types/line.png";
    public static final String CHART_SCATTER = "images/chart-types/scatter.png";
    public static final String CLOUD_GREY = "images/datacloud/cloudGrey.png";
    public static final String CLOUD_ORANGE = "images/datacloud/cloudOrange.png";
    public static final String CLOUD_GREEN = "images/datacloud/cloudGreen.png";
    public static final String CLOUD_RED = "images/datacloud/cloudRed.png";
    public static final String DICTIONARY_IMAGEPATH = "images/model/dictionary.png";
    public static final String DICTIONARY_SIMPLE_IMAGEPATH = "images/model/dictionary_simple.png";
    public static final String DICTIONARY_TEXTFILE_IMAGEPATH = "images/model/dictionary_textfile.png";
    public static final String DICTIONARY_DATASTORE_IMAGEPATH = "images/model/dictionary_datastore.png";
    public static final String NEWS_CHANNEL_READ_STATUS = "images/news/news_channel_read.png";
    public static final String NEWS_CHANNEL_TITLE_ICON = "images/news/news_channel_title.png";
    public static final String NEWS_CHANNEL_NOT_READ_STATUS = "images/news/news_channel_not_read.png";
    public static final String SYNONYM_CATALOG_IMAGEPATH = "images/model/synonym.png";
    public static final String SYNONYM_CATALOG_TEXTFILE_IMAGEPATH = "images/model/synonym_textfile.png";
    public static final String SYNONYM_CATALOG_DATASTORE_IMAGEPATH = "images/model/synonym_datastore.png";
    public static final String STRING_PATTERN_IMAGEPATH = "images/model/stringpattern.png";
    public static final String STRING_PATTERN_SIMPLE_IMAGEPATH = "images/model/stringpattern_simple.png";
    public static final String STRING_PATTERN_REGEX_IMAGEPATH = "images/model/stringpattern_regex.png";
    public static final String STRING_PATTERN_REGEXSWAP_IMAGEPATH = "images/model/stringpattern_regexswap.png";
    public static final String CLOUD_IMAGEPATH = "images/datastore-types/cloud.png";
    public static final String GENERIC_DATASTORE_IMAGEPATH = "images/model/datastore.png";
    public static final String CSV_IMAGEPATH = "images/datastore-types/csv.png";
    public static final String XML_IMAGEPATH = "images/datastore-types/xml.png";
    public static final String EXCEL_IMAGEPATH = "images/datastore-types/excel.png";
    public static final String ACCESS_IMAGEPATH = "images/datastore-types/access.png";
    public static final String DBASE_IMAGEPATH = "images/datastore-types/dbase.png";
    public static final String SAS_IMAGEPATH = "images/datastore-types/sas.png";
    public static final String FIXEDWIDTH_IMAGEPATH = "images/datastore-types/fixedwidth.png";
    public static final String ODB_IMAGEPATH = "images/datastore-types/odb.png";
    public static final String COMPOSITE_IMAGEPATH = "images/datastore-types/composite.png";
    public static final String MONGODB_IMAGEPATH = "images/datastore-types/mongodb.png";
    public static final String COUCHDB_IMAGEPATH = "images/datastore-types/couchdb.png";
    public static final String SALESFORCE_IMAGEPATH = "images/datastore-types/salesforce.png";
    public static final String SUGAR_CRM_IMAGEPATH = "images/datastore-types/sugarcrm.png";
    public static final String JSON_IMAGEPATH = "images/datastore-types/json.png";
    public static final String HBASE_IMAGEPATH = "images/datastore-types/hbase.png";
    public static final String CASSANDRA_IMAGEPATH = "images/datastore-types/cassandra.png";
    public static final String ELASTICSEARCH_IMAGEPATH = "images/datastore-types/elasticsearch.png";
    public static final String DATAHUB_IMAGEPATH = "images/datastore-types/datahub.png";
    public static final String NEO4J_IMAGEPATH = "images/datastore-types/neo4j.png";
    public static final String FILE_FOLDER = "images/filetypes/folder.png";
    public static final String FILE_ARCHIVE = "images/filetypes/archive.png";
    public static final String FILE_FILE = "images/filetypes/file.png";
    public static final String FILE_HDFS = "images/filetypes/hadoop.png";
    public static final String FILE_DESKTOP_FOLDER = "images/filetypes/desktop-folder.png";
    public static final String FILE_HOME_FOLDER = "images/filetypes/home-folder.png";
    public static final String FILE_HIDDEN_FOLDER = "images/filetypes/hidden-folder.png";
    public static final String FILE_SEARCH = "images/filetypes/search-folder.png";
    public static final String REMOTE_ICON_OVERLAY = "images/remote-icon-overlay.png";
    public static final String REMOTE_ICON_OVERLAY_SMALL = "images/remote-icon-overlay-small.png";
    public static final String PASSWORD_INPUT = "images/widgets/PasswordInput.png";
    public static final String USERNAME_INPUT = "images/widgets/UsernameInput.png";
    public static final String COMPONENT_TYPE_WRITE_DATA = "images/component-types/type_output_writer.png";
    private static final ImageManager _imageManager = ImageManager.get();

    private IconUtils() {
    }

    public static Icon getDescriptorIcon(ComponentDescriptor<?> descriptor, boolean configured, int iconWidth) {
        ImageIcon imageIcon;
        boolean serverDown = false;
        if (descriptor instanceof RemoteTransformerDescriptor && ((RemoteTransformerDescriptor)descriptor).getRemoteDescriptorProvider().getServerState().getActualState().equals((Object)RemoteServerState.State.ERROR)) {
            serverDown = true;
        }
        if (descriptor instanceof HasIcon && (imageIcon = IconUtils.getIconFromData(descriptor, iconWidth)) != null) {
            return serverDown ? IconUtils.addErrorOverlay(imageIcon) : imageIcon;
        }
        ImageIcon descriptorIcon = IconUtils.getDescriptorIcon(descriptor, iconWidth);
        if (configured) {
            return serverDown ? IconUtils.addErrorOverlay(descriptorIcon) : descriptorIcon;
        }
        return IconUtils.addErrorOverlay(descriptorIcon);
    }

    public static ImageIcon addErrorOverlay(ImageIcon imageIcon) {
        int offset = 4;
        int iconWidth = imageIcon.getIconWidth();
        int decorationSize = iconWidth / 2;
        Image errorImage = _imageManager.getImage(STATUS_ERROR, decorationSize, new ClassLoader[0]);
        BufferedImage bufferedImage = new BufferedImage(iconWidth + 4, iconWidth + 4, 2);
        bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 4, 0, null);
        bufferedImage.getGraphics().drawImage(errorImage, 0, iconWidth + 4 - decorationSize, null);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon getDescriptorIcon(ComponentDescriptor<?> descriptor, int newWidth) {
        return IconUtils.getDescriptorIcon(descriptor, newWidth, false);
    }

    public static ImageIcon getDescriptorIcon(ComponentDescriptor<?> descriptor, int newWidth, boolean allowTransparentForUnspecific) {
        boolean allowGeneric;
        ImageIcon imageIcon;
        if (descriptor instanceof HasIcon && (imageIcon = IconUtils.getIconFromData(descriptor, newWidth)) != null) {
            return imageIcon;
        }
        ClassLoader classLoader = descriptor.getComponentClass().getClassLoader();
        String imagePath = IconUtils.getDescriptorImagePath(descriptor, classLoader, allowGeneric = !allowTransparentForUnspecific);
        if (imagePath == null) {
            return IconUtils.getTransparentIcon(newWidth);
        }
        return _imageManager.getImageIcon(imagePath, newWidth, classLoader);
    }

    private static ImageIcon getIconFromData(ComponentDescriptor<?> componentDescriptor, int width) {
        ImageIcon imageIcon;
        String cacheKey = "remote: " + componentDescriptor.getDisplayName() + ",width=" + width;
        Image image = _imageManager.getImageFromCache(cacheKey);
        if (image == null) {
            HasIcon descriptorWithIcon = (HasIcon)componentDescriptor;
            if (descriptorWithIcon.getIconData() == null || descriptorWithIcon.getIconData().length == 0) {
                ClassLoader classLoader = componentDescriptor.getComponentClass().getClassLoader();
                String imagePath = IconUtils.getDescriptorImagePath(componentDescriptor, classLoader, true);
                if (imagePath == null) {
                    return null;
                }
                imageIcon = _imageManager.getImageIcon(imagePath, width, classLoader);
            } else {
                imageIcon = new ImageIcon(descriptorWithIcon.getIconData());
            }
            BufferedImage bufferedImage = new BufferedImage(width, width, 2);
            bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, width, width, null);
            imageIcon = new ImageIcon(bufferedImage);
            if (componentDescriptor instanceof Allowable && !((Allowable)componentDescriptor).isAllowed()) {
                imageIcon = IconUtils.getDisabledIcon(imageIcon);
            }
            imageIcon = IconUtils.addRemoteOverlay(imageIcon);
            _imageManager.storeImageIntoCache(cacheKey, imageIcon.getImage());
        } else {
            imageIcon = new ImageIcon(image);
        }
        return imageIcon;
    }

    public static ImageIcon addRemoteOverlay(ImageIcon imageIcon) {
        Image remoteIndicatorImage;
        int offset;
        int iconWidth = imageIcon.getIconWidth();
        if (iconWidth >= 32) {
            offset = 8;
            remoteIndicatorImage = _imageManager.getImage(REMOTE_ICON_OVERLAY, new ClassLoader[0]);
        } else {
            offset = 4;
            remoteIndicatorImage = _imageManager.getImage(REMOTE_ICON_OVERLAY_SMALL, new ClassLoader[0]);
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth + offset, iconWidth + offset, 2);
        bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, offset, null);
        bufferedImage.getGraphics().drawImage(remoteIndicatorImage, iconWidth - remoteIndicatorImage.getWidth(null) + offset, 0, null);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon getTransparentIcon(int width) {
        switch (width) {
            case 16: {
                return ICON_TRANSPARENT_SMALL;
            }
            case 22: {
                return ICON_TRANSPARENT_MEDIUM;
            }
            case 32: {
                return ICON_TRANSPARENT_LARGE;
            }
        }
        return IconUtils.createTransparentIcon(width);
    }

    private static ImageIcon createTransparentIcon(int width) {
        BufferedImage image = new BufferedImage(width, width, 6);
        return new ImageIcon(image);
    }

    public static ImageIcon getDescriptorIcon(ComponentDescriptor<?> descriptor) {
        return IconUtils.getDescriptorIcon(descriptor, 32);
    }

    public static ImageIcon getDatastoreIcon(Datastore datastore, int newWidth) {
        String imagePath = IconUtils.getDatastoreImagePath(datastore, true);
        return _imageManager.getImageIcon(imagePath, newWidth, new ClassLoader[0]);
    }

    public static ImageIcon getDatastoreIcon(Datastore datastore) {
        String imagePath = IconUtils.getDatastoreImagePath(datastore, true);
        return _imageManager.getImageIcon(imagePath, new ClassLoader[0]);
    }

    public static ImageIcon getComponentSuperCategoryIcon(ComponentSuperCategory superCategory) {
        return IconUtils.getComponentSuperCategoryIcon(superCategory, 32);
    }

    public static ImageIcon getComponentSuperCategoryIcon(ComponentSuperCategory superCategory, int newWidth) {
        Class<?> superCategoryClass = superCategory.getClass();
        return IconUtils.getCategoryIcon(superCategoryClass, false, newWidth);
    }

    public static ImageIcon getComponentCategoryIcon(ComponentCategory category) {
        return IconUtils.getComponentCategoryIcon(category, 32);
    }

    public static ImageIcon getComponentCategoryIcon(ComponentCategory category, int newWidth) {
        Class<?> categoryClass = category.getClass();
        return IconUtils.getCategoryIcon(categoryClass, true, newWidth);
    }

    private static ImageIcon getCategoryIcon(Class<?> cls, boolean decorateWithFolder, int newWidth) {
        Image decoration;
        String bundledIconPath = IconUtils.getImagePathForClass(cls);
        int totalSize = newWidth;
        if (!decorateWithFolder && bundledIconPath != null) {
            return _imageManager.getImageIcon(bundledIconPath, totalSize, new ClassLoader[0]);
        }
        int decorationSize = newWidth * 3 / 4;
        if (bundledIconPath == null) {
            decoration = null;
        } else {
            ClassLoader classLoader = cls.getClassLoader();
            decoration = _imageManager.getImage(bundledIconPath, decorationSize, classLoader);
        }
        Image folderIcon = _imageManager.getImage("images/component-types/category.png", totalSize, new ClassLoader[0]);
        if (decoration == null) {
            return new ImageIcon(folderIcon);
        }
        BufferedImage bufferedImage = new BufferedImage(totalSize, totalSize, 2);
        bufferedImage.getGraphics().drawImage(folderIcon, 0, 0, null);
        bufferedImage.getGraphics().drawImage(decoration, totalSize - decorationSize, totalSize - decorationSize, null);
        return new ImageIcon(bufferedImage);
    }

    public static Icon getDatastoreSpecificAnalysisJobIcon(Datastore datastore) {
        Image datastoreIcon;
        int decorationSize = 22;
        int totalWidth = 32;
        int totalHeight = 38;
        if (datastore == null) {
            datastoreIcon = _imageManager.getImage(GENERIC_DATASTORE_IMAGEPATH, 22, new ClassLoader[0]);
        } else {
            String datastoreImagePath = IconUtils.getDatastoreImagePath(datastore, false);
            datastoreIcon = _imageManager.getImage(datastoreImagePath, 22, new ClassLoader[0]);
        }
        Image jobIcon = _imageManager.getImage(MODEL_JOB, 22, new ClassLoader[0]);
        BufferedImage bufferedImage = new BufferedImage(32, 38, 2);
        bufferedImage.getGraphics().drawImage(jobIcon, 0, 0, null);
        bufferedImage.getGraphics().drawImage(datastoreIcon, 10, 16, null);
        return new ImageIcon(bufferedImage);
    }

    public static String getImagePathForClass(Class<?> cls) {
        return IconUtils.getImagePathForClass(cls, cls.getClassLoader());
    }

    public static String getImagePathForClass(Class<?> cls, ClassLoader classLoader) {
        String iconPath = cls.getName().replaceAll("\\.", "/") + ".png";
        URL url = ResourceManager.get().getUrl(iconPath, new ClassLoader[]{classLoader});
        if (url == null) {
            return null;
        }
        return iconPath;
    }

    protected static String getDescriptorImagePath(ComponentDescriptor<?> descriptor, ClassLoader classLoader, boolean allowGeneric) {
        Class componentClass = descriptor.getComponentClass();
        String bundledIconPath = IconUtils.getImagePathForClass(componentClass, classLoader);
        if (bundledIconPath != null) {
            return bundledIconPath;
        }
        if (!allowGeneric) {
            return null;
        }
        ComponentDescriptor<?> descriptorDescriptor = descriptor;
        Set categories = descriptorDescriptor.getComponentCategories();
        if (categories.contains(new WriteDataCategory())) {
            return COMPONENT_TYPE_WRITE_DATA;
        }
        if (descriptor instanceof TransformerDescriptor) {
            return TRANSFORMER_IMAGEPATH;
        }
        if (descriptor instanceof FilterDescriptor) {
            return FILTER_IMAGEPATH;
        }
        if (descriptor instanceof AnalyzerDescriptor) {
            return "images/component-types/analyzer.png";
        }
        return FILE_FILE;
    }

    public static Icon getColumnIcon(InputColumn<?> column, int iconSize) {
        if (column.isPhysicalColumn()) {
            return IconUtils.getColumnIcon(column.getPhysicalColumn(), iconSize);
        }
        return _imageManager.getImageIcon(MODEL_COLUMN, 16, new ClassLoader[0]);
    }

    public static Icon getColumnIcon(Column column, int iconSize) {
        if (column.isPrimaryKey()) {
            return _imageManager.getImageIcon(MODEL_COLUMN_KEY, iconSize, new ClassLoader[0]);
        }
        return _imageManager.getImageIcon(MODEL_COLUMN, iconSize, new ClassLoader[0]);
    }

    protected static String getDatastoreImagePath(Datastore datastore, boolean considerOrderdbSpecialization) {
        String imagePath = GENERIC_DATASTORE_IMAGEPATH;
        if (datastore == null) {
            return imagePath;
        }
        if (datastore instanceof JdbcDatastore) {
            JdbcDatastore jdbcDatastore = (JdbcDatastore)datastore;
            if (considerOrderdbSpecialization && "jdbc:hsqldb:res:orderdb;readonly=true".equals(jdbcDatastore.getJdbcUrl())) {
                imagePath = "images/datastore-types/orderdb.png";
            } else {
                DatabaseDriverDescriptor driver;
                String driverClass = jdbcDatastore.getDriverClass();
                if (!StringUtils.isNullOrEmpty((String)driverClass) && (driver = DatabaseDriverCatalog.getDatabaseDriverByDriverClassName((String)driverClass)) != null) {
                    imagePath = driver.getIconImagePath();
                }
            }
        } else if (datastore instanceof CsvDatastore) {
            imagePath = CSV_IMAGEPATH;
        } else if (datastore instanceof ExcelDatastore) {
            imagePath = EXCEL_IMAGEPATH;
        } else if (datastore instanceof AccessDatastore) {
            imagePath = ACCESS_IMAGEPATH;
        } else if (datastore instanceof OdbDatastore) {
            imagePath = ODB_IMAGEPATH;
        } else if (datastore instanceof FixedWidthDatastore) {
            imagePath = FIXEDWIDTH_IMAGEPATH;
        } else if (datastore instanceof DbaseDatastore) {
            imagePath = DBASE_IMAGEPATH;
        } else if (datastore instanceof SasDatastore) {
            imagePath = SAS_IMAGEPATH;
        } else if (datastore instanceof XmlDatastore) {
            imagePath = XML_IMAGEPATH;
        } else if (datastore instanceof HBaseDatastore) {
            imagePath = HBASE_IMAGEPATH;
        } else if (datastore instanceof ElasticSearchDatastore) {
            imagePath = ELASTICSEARCH_IMAGEPATH;
        } else if (datastore instanceof CassandraDatastore) {
            imagePath = CASSANDRA_IMAGEPATH;
        } else if (datastore instanceof JsonDatastore) {
            imagePath = JSON_IMAGEPATH;
        } else if (datastore instanceof CouchDbDatastore) {
            imagePath = COUCHDB_IMAGEPATH;
        } else if (datastore instanceof MongoDbDatastore) {
            imagePath = MONGODB_IMAGEPATH;
        } else if (datastore instanceof SalesforceDatastore) {
            imagePath = SALESFORCE_IMAGEPATH;
        } else if (datastore instanceof SugarCrmDatastore) {
            imagePath = SUGAR_CRM_IMAGEPATH;
        } else if (datastore instanceof CompositeDatastore) {
            imagePath = COMPOSITE_IMAGEPATH;
        } else if (datastore instanceof DataHubDatastore) {
            imagePath = DATAHUB_IMAGEPATH;
        } else if (datastore instanceof Neo4jDatastore) {
            imagePath = NEO4J_IMAGEPATH;
        }
        return imagePath;
    }

    public static ImageIcon getDisabledIcon(ImageIcon inputIcon) {
        DisabledFilter filter = new DisabledFilter();
        FilteredImageSource prod = new FilteredImageSource(inputIcon.getImage().getSource(), filter);
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
    }

    private static class DisabledFilter
    extends RGBImageFilter {
        private DisabledFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (rgb >> 24 == 0) {
                return rgb;
            }
            int red = new Color(rgb).getRed();
            int green = new Color(rgb).getGreen();
            int blue = new Color(rgb).getBlue();
            int max = Math.max(Math.max(red, green), blue);
            int min = Math.min(Math.min(red, green), blue);
            int gray = this.brighter((max + min) / 2, 40);
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray;
        }

        private int brighter(int rgb, int percent) {
            double q = (double)(255 * percent) * 0.01;
            double k = (255.0 - q) / 255.0;
            return (int)(k * (double)rgb + q);
        }
    }
}

