/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.DCComboBoxUI;
import org.datacleaner.widgets.DCScrollBarUI;
import org.datacleaner.widgets.tooltip.DCPopupFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LookAndFeelManager {
    private static final Logger logger = LoggerFactory.getLogger(LookAndFeelManager.class);
    private static final LookAndFeelManager instance = new LookAndFeelManager();
    private static final ImageManager imageManager = ImageManager.get();

    public static LookAndFeelManager get() {
        return instance;
    }

    @Deprecated
    public static LookAndFeelManager getInstance() {
        return LookAndFeelManager.get();
    }

    private LookAndFeelManager() {
    }

    public void init() {
        try {
            PlasticXPLookAndFeel laf = new PlasticXPLookAndFeel();
            UIManager.setLookAndFeel((LookAndFeel)laf);
            logger.info("Look and feel set to: {}", (Object)UIManager.getLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new IllegalStateException(e);
        }
        UIManager.put("ClassLoader", LookUtils.class.getClassLoader());
        Set propertyKeys = UIManager.getLookAndFeelDefaults().keySet();
        for (Object propertyKey : propertyKeys) {
            if (!(propertyKey instanceof String)) continue;
            String str = (String)propertyKey;
            if (str.endsWith(".font")) {
                UIManager.put(propertyKey, WidgetUtils.FONT_NORMAL);
                continue;
            }
            if (!str.endsWith(".background")) continue;
            UIManager.put(propertyKey, WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        }
        ToolTipManager.sharedInstance().setInitialDelay(500);
        PopupFactory.setSharedInstance(new DCPopupFactory());
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        UIManager.put("ScrollPane.border", emptyBorder);
        UIManager.put("OptionPane.background", WidgetUtils.COLOR_WELL_BACKGROUND);
        UIManager.put("Panel.background", WidgetUtils.COLOR_WELL_BACKGROUND);
        UIManager.put("List.selectionForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("List.selectionBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("List.focusCellHighlightBorder", WidgetUtils.BORDER_THIN);
        UIManager.put("Tree.selectionForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("Tree.selectionBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("Tree.selectionBorderColor", WidgetUtils.BG_COLOR_MEDIUM);
        UIManager.put("Table.selectionForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("Table.selectionBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("Table.focusCellHighlightBorder", WidgetUtils.BORDER_THIN);
        UIManager.put("SplitPane.border", new EmptyBorder(0, 0, 0, 0));
        UIManager.put("SplitPaneDivider.border", new EmptyBorder(0, 0, 0, 0));
        Color menuBackground = WidgetUtils.BG_COLOR_LESS_BRIGHT;
        UIManager.put("PopupMenu.background", menuBackground);
        UIManager.put("PopupMenu.foreground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("PopupMenu.border", emptyBorder);
        UIManager.put("Menu.background", menuBackground);
        UIManager.put("Menu.foreground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("Menu.border", WidgetUtils.BORDER_MENU_ITEM);
        UIManager.put("MenuItem.selectionForeground", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("MenuItem.selectionBackground", WidgetUtils.BG_COLOR_BLUE_DARK);
        UIManager.put("MenuItem.background", menuBackground);
        UIManager.put("MenuItem.foreground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("MenuItem.border", WidgetUtils.BORDER_MENU_ITEM);
        UIManager.put("MenuBar.background", menuBackground);
        UIManager.put("MenuBar.foreground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("MenuBar.border", emptyBorder);
        Color separatorColor = WidgetUtils.slightlyDarker(menuBackground);
        UIManager.put("Separator.background", separatorColor);
        UIManager.put("Separator.foreground", separatorColor);
        UIManager.put("Separator.highlight", separatorColor);
        UIManager.put("Separator.shadow", separatorColor);
        UIManager.put("Tree.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("EditorPane.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("Spinner.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TextField.border", WidgetUtils.BORDER_INPUT);
        UIManager.put("TextField.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TextField.disabledBackground", WidgetUtils.BG_COLOR_BRIGHT);
        UIManager.put("TextArea.border", WidgetUtils.BORDER_INPUT);
        UIManager.put("TextArea.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("PasswordField.border", WidgetUtils.BORDER_INPUT);
        UIManager.put("PasswordField.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("PasswordField.disabledBackground", WidgetUtils.BG_COLOR_BRIGHT);
        UIManager.put("FormattedTextField.border", WidgetUtils.BORDER_INPUT);
        UIManager.put("FormattedTextField.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("ComboBox.border", WidgetUtils.BORDER_INPUT);
        UIManager.put("ComboBox.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("ComboBox.arrowButtonBorder", BorderFactory.createEmptyBorder());
        UIManager.put("ComboBox.editorBorder", BorderFactory.createEmptyBorder());
        UIManager.put("ComboBox.selectionBackground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("ComboBoxUI", DCComboBoxUI.class.getName());
        UIManager.put("TableHeader.background", WidgetUtils.COLOR_WELL_BACKGROUND);
        UIManager.put("TableHeader.focusCellBackground", WidgetUtils.COLOR_WELL_BACKGROUND);
        UIManager.put("TableHeader.foreground", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("TableHeader.font", WidgetUtils.FONT_TABLE_HEADER);
        UIManager.put("TableHeader.cellBorder", new CompoundBorder(new MatteBorder(0, 0, 0, 1, WidgetUtils.BG_COLOR_LESS_BRIGHT), WidgetUtils.BORDER_EMPTY));
        UIManager.put("TitledBorder.font", WidgetUtils.FONT_HEADER1);
        UIManager.put("TitledBorder.titleColor", WidgetUtils.BG_COLOR_BLUE_MEDIUM);
        UIManager.put("ToolTip.background", WidgetUtils.COLOR_ALTERNATIVE_BACKGROUND);
        UIManager.put("ToolTip.foreground", WidgetUtils.BG_COLOR_BRIGHT);
        UIManager.put("ToolTip.border", WidgetUtils.BORDER_WIDE_ALTERNATIVE);
        UIManager.put("TaskPaneContainer.background", WidgetUtils.COLOR_WELL_BACKGROUND);
        UIManager.put("TaskPane.background", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("TaskPane.font", WidgetUtils.FONT_TABLE_HEADER);
        UIManager.put("TaskPane.titleForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TaskPane.titleBackgroundGradientStart", WidgetUtils.COLOR_ALTERNATIVE_BACKGROUND);
        UIManager.put("TaskPane.titleBackgroundGradientEnd", WidgetUtils.COLOR_ALTERNATIVE_BACKGROUND);
        UIManager.put("TaskPane.borderColor", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("ScrollBar.thumb", WidgetUtils.BG_COLOR_LESS_BRIGHT);
        UIManager.put("ScrollBar.thumbHighlight", WidgetUtils.slightlyDarker(WidgetUtils.BG_COLOR_LESS_BRIGHT));
        UIManager.put("ScrollBar.thumbShadow", WidgetUtils.slightlyDarker(WidgetUtils.BG_COLOR_LESS_BRIGHT));
        UIManager.put("ScrollBar.thumbDarkShadow", WidgetUtils.BG_COLOR_LESS_BRIGHT);
        UIManager.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
        UIManager.put("ScrollBar.highlight", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.shadow", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.darkShadow", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.background", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.foreground", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.track", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.trackForeground", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.trackHighlight", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBar.trackHighlightForeground", WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        UIManager.put("ScrollBarUI", DCScrollBarUI.class.getName());
        UIManager.put("ProgressBar.foreground", WidgetUtils.BG_COLOR_BLUE_BRIGHT);
        UIManager.put("FileChooser.detailsViewIcon", imageManager.getImageIcon("images/filetypes/view-details.png", new ClassLoader[0]));
        UIManager.put("FileChooser.listViewIcon", imageManager.getImageIcon("images/filetypes/view-list.png", new ClassLoader[0]));
        UIManager.put("FileChooser.homeFolderIcon", imageManager.getImageIcon("images/filetypes/home-folder.png", new ClassLoader[0]));
        UIManager.put("FileChooser.newFolderIcon", imageManager.getImageIcon("images/filetypes/new-folder.png", new ClassLoader[0]));
        UIManager.put("FileChooser.upFolderIcon", imageManager.getImageIcon("images/filetypes/parent-folder.png", new ClassLoader[0]));
        UIManager.put("JXMonthView.foreground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.monthStringForeground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.daysOfTheWeekForeground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.weekOfTheYearForeground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.unselectableDayForeground", WidgetUtils.BG_COLOR_MEDIUM);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(WidgetUtils.FONT_NORMAL);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        ToolTipManager.sharedInstance().setInitialDelay(100);
    }
}

