/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.ErrorUtils;
import org.datacleaner.util.ResourceManager;
import org.datacleaner.util.StringUtils;
import org.datacleaner.widgets.DarkButtonUI;
import org.datacleaner.widgets.DarkToggleButtonUI;
import org.datacleaner.widgets.DefaultButtonUI;
import org.datacleaner.widgets.DefaultToggleButtonUI;
import org.datacleaner.widgets.PrimaryButtonUI;
import org.datacleaner.widgets.table.DCTablePanel;
import org.datacleaner.windows.ErrorDialog;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.border.DropShadowBorder;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WidgetUtils {
    private static final Logger logger;
    public static final float FONT_SIZE_SMALL = 11.0f;
    private static final Map<String, Font> fonts;
    @Deprecated
    public static final Font FONT_UBUNTU_PLAIN;
    @Deprecated
    public static final Font FONT_UBUNTU_BOLD;
    @Deprecated
    public static final Font FONT_UBUNTU_ITALIC;
    @Deprecated
    public static final Font FONT_UBUNTU_BOLD_ITALIC;
    @Deprecated
    public static final Font FONT_OPENSANS_PLAIN;
    @Deprecated
    public static final Font FONT_OPENSANS_BOLD;
    @Deprecated
    public static final Font FONT_OPENSANS_ITALIC;
    @Deprecated
    public static final Font FONT_OPENSANS_BOLD_ITALIC;
    private static final Font FONT_MULI_PLAIN;
    private static final Font FONT_MULI_BOLD;
    private static final Font FONT_MULI_LIGHT;
    private static final Font FONT_MULI_LIGHT_ITALIC;
    private static final Font FONT_LATO_BOLD;
    private static final Font FONT_LATO_BOLD_ITALIC;
    public static final Font FONT_FONTAWESOME;
    public static final Font FONT_BANNER;
    public static final Font FONT_HEADER1;
    public static final Font FONT_HEADER2;
    public static final Font FONT_MONOSPACE;
    public static final Font FONT_BUTTON;
    public static final Font FONT_NORMAL;
    public static final Font FONT_BOLD;
    public static final Font FONT_SMALL;
    public static final Font FONT_TABLE_HEADER;
    public static final int SCROLL_UNIT_INCREMENT = 20;
    public static final Color BG_COLOR_BLUE_MEDIUM;
    public static final Color BG_COLOR_BLUE_BRIGHT;
    public static final Color BG_COLOR_BLUE_DARK;
    public static final Color BG_COLOR_GREEN_MEDIUM;
    public static final Color BG_COLOR_GREEN_BRIGHT;
    public static final Color BG_COLOR_GREEN_DARK;
    public static final Color BG_COLOR_ORANGE_MEDIUM;
    public static final Color BG_COLOR_ORANGE_BRIGHT;
    public static final Color BG_COLOR_ORANGE_DARK;
    public static final Color BG_SEMI_TRANSPARENT;
    @Deprecated
    public static final Color BG_COLOR_PALE_YELLOW;
    public static final Color BG_COLOR_BRIGHTEST;
    public static final Color BG_COLOR_BRIGHT;
    public static final Color BG_COLOR_LESS_BRIGHT;
    public static final Color BG_COLOR_MEDIUM;
    public static final Color BG_COLOR_LESS_DARK;
    public static final Color BG_COLOR_DARK;
    public static final Color BG_COLOR_DARKEST;
    public static final Color COLOR_DEFAULT_BACKGROUND;
    public static final Color COLOR_WELL_BACKGROUND;
    public static final Color COLOR_ALTERNATIVE_BACKGROUND;
    @Deprecated
    public static final Color ADDITIONAL_COLOR_GREEN_BRIGHT;
    public static final Color ADDITIONAL_COLOR_RED_BRIGHT;
    public static final Color ADDITIONAL_COLOR_PURPLE_BRIGHT;
    public static final Color ADDITIONAL_COLOR_CYAN_BRIGHT;
    public static final int BORDER_WIDE_WIDTH = 4;
    public static final Border BORDER_SHADOW;
    public static final Border BORDER_WIDE_ALTERNATIVE;
    public static final Border BORDER_WIDE_DEFAULT;
    public static final Border BORDER_WIDE_WELL;
    @Deprecated
    public static final Border BORDER_WIDE;
    @Deprecated
    public static final Border BORDER_WIDE_BRIGHTEST;
    public static final Border BORDER_EMPTY;
    public static Border BORDER_TOP_PADDING;
    public static final Border BORDER_THIN;
    public static final Border BORDER_THIN_DARK;
    public static final Border BORDER_LIST_ITEM;
    public static final Border BORDER_LIST_ITEM_LEFT_ONLY;
    public static final Border BORDER_LIST_ITEM_HIGHLIGHTED;
    public static final Border BORDER_LIST_ITEM_SUBTLE;
    public static final Border BORDER_EMPHASIZE_FIELD;
    public static final Border BORDER_INPUT;
    public static final Border BORDER_TABLE_PANEL;
    public static final Border BORDER_CHECKBOX_LIST_INDENTATION;
    public static final Border BORDER_BUTTON_DARK;
    public static final Border BORDER_BUTTON_DARK_WITH_LINE;
    public static final Border BORDER_BUTTON_DEFAULT;
    public static final Border BORDER_BUTTON_PRIMARY;
    public static final Object BORDER_MENU_ITEM;
    public static final Highlighter LIBERELLO_HIGHLIGHTER;
    private static final double COLOR_SCALE_FACTOR = 0.9;
    public static final int DEFAULT_PADDING = 2;
    public static final int DEFAULT_ANCHOR = 17;
    public static final Insets INSETS_EMPTY;
    public static final String CHAR_CARET_DOWN = "\uf0d7";

    private WidgetUtils() {
    }

    public static void invokeSwingAction(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static Font createFont(String path) {
        Font font;
        URL url = ResourceManager.get().getUrl(path, new ClassLoader[0]);
        if (url == null) {
            throw new IllegalArgumentException("Font resource not found: " + path);
        }
        InputStream in = null;
        try {
            in = url.openStream();
            font = Font.createFont(0, in);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{in});
        return font;
    }

    public static void centerOnScreen(Component component) {
        Dimension paneSize = component.getSize();
        Dimension screenSize = component.getToolkit().getScreenSize();
        component.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, width, height, anchor, 2);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor, int padding) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, width, height, anchor, padding, 0.0, 0.0);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor, int padding, double weightx, double weighty) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, width, height, anchor, padding, weightx, weighty, 2);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor, int padding, double weightx, double weighty, int fill) {
        LayoutManager layout = panel.getLayout();
        if (!(layout instanceof GridBagLayout)) {
            layout = new GridBagLayout();
            panel.setLayout(layout);
        }
        GridBagLayout gridBagLayout = (GridBagLayout)layout;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = new Insets(padding, padding, padding, padding);
        gridBagLayout.addLayoutComponent(comp, constraints);
        panel.add(comp);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, width, height, 17);
    }

    public static void addToGridBag(Component comp, JPanel panel, int x, int y, int anchor, double weightx, double weighty) {
        WidgetUtils.addToGridBag(comp, panel, x, y, 1, 1, anchor, 2, weightx, weighty);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, 1, 1);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, double weightx, double weighty) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, 1, 1, 17, 2, weightx, weighty);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int anchor) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, 1, 1, anchor);
    }

    public static void addAligned(Container container, JComponent component) {
        component.setAlignmentX(0.0f);
        component.setAlignmentY(0.0f);
        container.add(component);
    }

    public static void showErrorMessage(String shortMessage, String detailedMessage) {
        String finalDetailedMessage = detailedMessage == null ? "" : detailedMessage;
        String finalShortMessage = shortMessage == null ? "" : shortMessage;
        ErrorDialog dialog = new ErrorDialog(finalShortMessage, finalDetailedMessage);
        dialog.setModal(true);
        dialog.open();
    }

    public static void showErrorMessage(String shortMessage, String detailedMessage, Throwable exception) {
        Throwable presentedException = ErrorUtils.unwrapForPresentation((Throwable)exception);
        if (exception == null) {
            WidgetUtils.showErrorMessage(shortMessage, detailedMessage);
            return;
        }
        String finalDetailedMessage = detailedMessage == null ? "" : detailedMessage;
        String finalShortMessage = shortMessage == null ? "" : shortMessage;
        ErrorInfo info = new ErrorInfo(finalShortMessage, finalDetailedMessage, null, "error", presentedException, ErrorLevel.SEVERE, null);
        JXErrorPane errorPane = new JXErrorPane();
        errorPane.setErrorInfo(info);
        JDialog dialog = JXErrorPane.createDialog(null, (JXErrorPane)errorPane);
        WidgetUtils.centerOnScreen(dialog);
        JXErrorPane.setDefaultLocale((Locale)Locale.ENGLISH);
        dialog.setLocale(Locale.ENGLISH);
        dialog.setModal(true);
        dialog.setTitle(finalShortMessage);
        dialog.setVisible(true);
        dialog.toFront();
    }

    public static void showErrorMessage(String shortMessage, Throwable exception) {
        StringBuilder sb = new StringBuilder();
        for (Throwable e = exception; e != null; e = e.getCause()) {
            String message;
            if (sb.length() != 0) {
                sb.append("\n\n");
            }
            if (StringUtils.isNullOrEmpty((String)(message = e.getMessage()))) {
                message = "(" + e.getClass().getName() + ")";
            }
            sb.append(message);
        }
        WidgetUtils.showErrorMessage(shortMessage, sb.toString(), exception);
    }

    public static JScrollPane scrollable(JComponent comp, int maxHeight) {
        JScrollPane scrollPane = WidgetUtils.scrolleable(comp);
        if (comp.getPreferredSize().getHeight() > (double)maxHeight) {
            Dimension preferredSize = comp.getPreferredSize();
            Dimension newSize = new Dimension(preferredSize.width, maxHeight);
            scrollPane.getViewport().setPreferredSize(newSize);
        }
        return scrollPane;
    }

    public static JScrollPane scrolleable(JComponent comp) {
        JScrollPane scroll = new JScrollPane();
        if (comp != null) {
            scroll.setViewportView(comp);
        }
        scroll.getVerticalScrollBar().setUnitIncrement(20);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        return scroll;
    }

    public static Color colorBetween(Color c1, Color c2) {
        int red = (c1.getRed() + c2.getRed()) / 2;
        int green = (c1.getGreen() + c2.getGreen()) / 2;
        int blue = (c1.getBlue() + c2.getBlue()) / 2;
        return new Color(red, green, blue);
    }

    public static Color slightlyDarker(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.9), 0), Math.max((int)((double)color.getGreen() * 0.9), 0), Math.max((int)((double)color.getBlue() * 0.9), 0));
    }

    public static Color slightlyBrighter(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int i = 10;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.9), 255), Math.min((int)((double)g / 0.9), 255), Math.min((int)((double)b / 0.9), 255));
    }

    public static String extractText(Component comp) {
        if (comp instanceof JLabel) {
            return ((JLabel)comp).getText();
        }
        if (comp instanceof JTextComponent) {
            return ((JTextComponent)comp).getText();
        }
        if (comp instanceof Container) {
            Component[] children = ((Container)comp).getComponents();
            StringBuilder sb = new StringBuilder();
            for (Component child : children) {
                String text = WidgetUtils.extractText(child);
                if (StringUtils.isNullOrEmpty((String)text)) continue;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(text);
            }
            return sb.toString();
        }
        logger.warn("Could not extract text from component: {}", (Object)comp);
        return "";
    }

    public static DCPanel decorateWithShadow(JComponent comp) {
        boolean outline = !(comp instanceof DCTablePanel);
        return WidgetUtils.decorateWithShadow(comp, outline, 4);
    }

    public static DCPanel decorateWithShadow(JComponent comp, boolean outline, int margin) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        Border border = BORDER_SHADOW;
        if (outline) {
            border = new CompoundBorder(border, BORDER_THIN);
        }
        if (margin > 0) {
            border = new CompoundBorder(new EmptyBorder(margin, margin, margin, margin), border);
        }
        panel.setBorder(border);
        panel.add((Component)comp, "Center");
        return panel;
    }

    public static Font findCompatibleFont(String text, Font fallbackFont) {
        String[] searchFonts;
        for (String fontName : searchFonts = new String[]{"SansSerif", "Serif", "Verdana", "Arial Unicode MS", "MS UI Gothic", "MS Mincho", "MS Gothic", "Osaka"}) {
            Font font = fonts.get(fontName);
            if (font == null) {
                font = new Font(fontName, fallbackFont.getStyle(), fallbackFont.getSize());
            }
            if (font.canDisplayUpTo(text) != -1) continue;
            logger.info("Font '{}' was capable, returning", (Object)fontName);
            font = font.deriveFont(fallbackFont.getSize2D());
            return font;
        }
        logger.warn("Didn't find any capable fonts for text '{}'", (Object)text);
        return fallbackFont;
    }

    public static void setAppropriateFont(JLabel label) {
        String text = label.getText();
        if (text == null) {
            return;
        }
        Font font = label.getFont();
        int canDisplay = font.canDisplayUpTo(text);
        if (canDisplay != -1) {
            logger.info("Default font ('{}') was unable to display text ('{}'), searching for alternative.", (Object)font.getName(), (Object)text);
            font = WidgetUtils.findCompatibleFont(text, font);
            label.setFont(font);
        }
    }

    public static void setPrimaryButtonStyle(AbstractButton b) {
        b.setUI((ButtonUI)((Object)PrimaryButtonUI.get()));
    }

    public static void setDarkButtonStyle(AbstractButton b) {
        if (b instanceof JToggleButton) {
            b.setUI(DarkToggleButtonUI.get());
        } else {
            b.setUI(DarkButtonUI.get());
        }
    }

    public static void setDefaultButtonStyle(AbstractButton b) {
        if (b instanceof JToggleButton) {
            b.setUI(DefaultToggleButtonUI.get());
        } else {
            b.setUI(DefaultButtonUI.get());
        }
    }

    static {
        Font[] fontArray;
        logger = LoggerFactory.getLogger(WidgetUtils.class);
        fonts = new HashMap<String, Font>();
        for (Font font : fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!font.isPlain()) continue;
            fonts.put(font.getName(), font);
        }
        FONT_MULI_PLAIN = WidgetUtils.createFont("fonts/Muli.ttf");
        FONT_MULI_BOLD = WidgetUtils.createFont("fonts/Muli-Bold.ttf");
        FONT_MULI_LIGHT = WidgetUtils.createFont("fonts/Muli-Light.ttf");
        FONT_MULI_LIGHT_ITALIC = WidgetUtils.createFont("fonts/Muli-LightItalic.ttf");
        FONT_LATO_BOLD = WidgetUtils.createFont("fonts/Lato-Bold.ttf");
        FONT_LATO_BOLD_ITALIC = WidgetUtils.createFont("fonts/Lato-BoldItalic.ttf");
        FONT_UBUNTU_PLAIN = FONT_MULI_PLAIN;
        FONT_UBUNTU_ITALIC = FONT_MULI_LIGHT_ITALIC;
        FONT_UBUNTU_BOLD = FONT_LATO_BOLD;
        FONT_UBUNTU_BOLD_ITALIC = FONT_LATO_BOLD_ITALIC;
        FONT_OPENSANS_PLAIN = FONT_MULI_PLAIN;
        FONT_OPENSANS_ITALIC = FONT_MULI_LIGHT_ITALIC;
        FONT_OPENSANS_BOLD = FONT_LATO_BOLD;
        FONT_OPENSANS_BOLD_ITALIC = FONT_LATO_BOLD_ITALIC;
        FONT_FONTAWESOME = WidgetUtils.createFont("fonts/FontAwesome-4.3.0.ttf").deriveFont(14.0f);
        fonts.put(FONT_MULI_PLAIN.getName(), FONT_MULI_PLAIN);
        FONT_BANNER = FONT_MULI_LIGHT.deriveFont(21.0f);
        FONT_HEADER1 = FONT_MULI_LIGHT.deriveFont(18.0f);
        FONT_HEADER2 = FONT_MULI_LIGHT.deriveFont(16.0f);
        FONT_MONOSPACE = new FontUIResource("Monospaced", 0, 14);
        FONT_BUTTON = FONT_MULI_PLAIN.deriveFont(14.0f);
        FONT_NORMAL = FONT_MULI_PLAIN.deriveFont(13.0f);
        FONT_BOLD = FONT_MULI_BOLD.deriveFont(13.0f);
        FONT_SMALL = FONT_MULI_PLAIN.deriveFont(11.0f);
        FONT_TABLE_HEADER = FONT_NORMAL.deriveFont(1);
        BG_COLOR_BLUE_MEDIUM = new ColorUIResource(5, 185, 240);
        BG_COLOR_BLUE_BRIGHT = WidgetUtils.slightlyBrighter(BG_COLOR_BLUE_MEDIUM);
        BG_COLOR_BLUE_DARK = WidgetUtils.slightlyDarker(BG_COLOR_BLUE_MEDIUM);
        BG_COLOR_GREEN_MEDIUM = new ColorUIResource(122, 190, 68);
        BG_COLOR_GREEN_BRIGHT = WidgetUtils.slightlyBrighter(BG_COLOR_GREEN_MEDIUM);
        BG_COLOR_GREEN_DARK = WidgetUtils.slightlyDarker(BG_COLOR_GREEN_MEDIUM);
        BG_COLOR_ORANGE_MEDIUM = new ColorUIResource(245, 129, 50);
        BG_COLOR_ORANGE_BRIGHT = WidgetUtils.slightlyBrighter(BG_COLOR_ORANGE_MEDIUM);
        BG_COLOR_ORANGE_DARK = WidgetUtils.slightlyDarker(BG_COLOR_ORANGE_MEDIUM);
        BG_SEMI_TRANSPARENT = new ColorUIResource(new Color(0.0f, 0.0f, 0.0f, 0.05f));
        BG_COLOR_PALE_YELLOW = new ColorUIResource(244, 244, 211);
        BG_COLOR_BRIGHTEST = new ColorUIResource(Color.WHITE);
        BG_COLOR_BRIGHT = new ColorUIResource(245, 245, 245);
        BG_COLOR_LESS_BRIGHT = new ColorUIResource(220, 220, 220);
        BG_COLOR_MEDIUM = new ColorUIResource(130, 140, 150);
        BG_COLOR_LESS_DARK = new ColorUIResource(55, 55, 55);
        BG_COLOR_DARK = new ColorUIResource(33, 33, 33);
        BG_COLOR_DARKEST = new ColorUIResource(Color.BLACK);
        COLOR_DEFAULT_BACKGROUND = BG_COLOR_BRIGHTEST;
        COLOR_WELL_BACKGROUND = BG_COLOR_BRIGHT;
        COLOR_ALTERNATIVE_BACKGROUND = BG_COLOR_DARK;
        ADDITIONAL_COLOR_GREEN_BRIGHT = BG_COLOR_GREEN_MEDIUM;
        ADDITIONAL_COLOR_RED_BRIGHT = new ColorUIResource(211, 36, 36);
        ADDITIONAL_COLOR_PURPLE_BRIGHT = new ColorUIResource(211, 36, 156);
        ADDITIONAL_COLOR_CYAN_BRIGHT = new ColorUIResource(36, 209, 211);
        BORDER_SHADOW = new DropShadowBorder(BG_COLOR_DARK, 6);
        BORDER_WIDE_ALTERNATIVE = new LineBorder(COLOR_ALTERNATIVE_BACKGROUND, 4);
        BORDER_WIDE_DEFAULT = new LineBorder(COLOR_DEFAULT_BACKGROUND, 4);
        BORDER_WIDE_WELL = new LineBorder(COLOR_WELL_BACKGROUND, 4);
        BORDER_WIDE = BORDER_WIDE_ALTERNATIVE;
        BORDER_WIDE_BRIGHTEST = BORDER_WIDE_DEFAULT;
        BORDER_EMPTY = new EmptyBorder(4, 4, 4, 4);
        BORDER_TOP_PADDING = new EmptyBorder(10, 0, 0, 0);
        BORDER_THIN = new LineBorder(BG_COLOR_LESS_BRIGHT);
        BORDER_THIN_DARK = new LineBorder(BG_COLOR_DARK);
        BORDER_LIST_ITEM = new CompoundBorder(new MatteBorder(0, 3, 0, 0, BG_COLOR_BLUE_MEDIUM), new MatteBorder(0, 0, 1, 0, BG_COLOR_LESS_BRIGHT));
        BORDER_LIST_ITEM_LEFT_ONLY = new CompoundBorder(new MatteBorder(0, 3, 0, 0, BG_COLOR_BLUE_MEDIUM), new EmptyBorder(0, 0, 1, 0));
        BORDER_LIST_ITEM_HIGHLIGHTED = new CompoundBorder(new MatteBorder(0, 3, 0, 0, BG_COLOR_BLUE_MEDIUM), new MatteBorder(0, 0, 1, 0, BG_COLOR_BLUE_MEDIUM));
        BORDER_LIST_ITEM_SUBTLE = new CompoundBorder(new MatteBorder(0, 3, 0, 0, BG_COLOR_BLUE_MEDIUM), new MatteBorder(0, 0, 1, 0, BG_COLOR_MEDIUM));
        BORDER_EMPHASIZE_FIELD = new LineBorder(ADDITIONAL_COLOR_RED_BRIGHT, 2, false);
        BORDER_INPUT = new CompoundBorder(BORDER_THIN, BORDER_EMPTY);
        BORDER_TABLE_PANEL = new MatteBorder(1, 1, 0, 0, BG_COLOR_LESS_BRIGHT);
        BORDER_CHECKBOX_LIST_INDENTATION = new EmptyBorder(1, 17, 0, 1);
        BORDER_BUTTON_DARK = new EmptyBorder(4, 10, 4, 10);
        BORDER_BUTTON_DARK_WITH_LINE = new CompoundBorder(new LineBorder(BG_COLOR_LESS_DARK, 1, false), new EmptyBorder(3, 9, 3, 9));
        BORDER_BUTTON_DEFAULT = new CompoundBorder(new LineBorder(BG_COLOR_LESS_BRIGHT, 1, false), new EmptyBorder(3, 9, 3, 9));
        BORDER_BUTTON_PRIMARY = new EmptyBorder(4, 10, 4, 10);
        BORDER_MENU_ITEM = new EmptyBorder(2, 2, 2, 2);
        LIBERELLO_HIGHLIGHTER = HighlighterFactory.createAlternateStriping((Color)WidgetUtils.colorBetween(BG_COLOR_BRIGHTEST, BG_COLOR_BRIGHT), (Color)BG_COLOR_BRIGHTEST);
        INSETS_EMPTY = new Insets(0, 0, 0, 0);
    }
}

