/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.awt.Dimension;
import java.util.Map;
import org.datacleaner.user.UserPreferences;

public class WindowSizePreferences {
    private final UserPreferences _userPreferences;
    private final String _identifier;
    private final int _defaultWidth;
    private final int _defaultHeight;

    public WindowSizePreferences(UserPreferences userPreferences, Class<?> windowClass, int defaultWidth, int defaultHeight) {
        this._identifier = windowClass.getName();
        this._defaultWidth = defaultWidth;
        this._defaultHeight = defaultHeight;
        this._userPreferences = userPreferences;
    }

    public UserPreferences getUserPreferences() {
        return this._userPreferences;
    }

    public boolean isWindowMaximized() {
        Map properties = this._userPreferences.getAdditionalProperties();
        String isMaximized = (String)properties.get(this.getIsMaximizedWindowPropertyKey());
        if (isMaximized == null) {
            return true;
        }
        return Boolean.parseBoolean(isMaximized);
    }

    public Dimension getUserPreferredSize() {
        String heightStr;
        Map properties = this._userPreferences.getAdditionalProperties();
        String widthStr = (String)properties.get(this.getWidthPropertyKey());
        if (widthStr == null) {
            widthStr = "" + this._defaultWidth;
        }
        if ((heightStr = (String)properties.get(this.getHeightPropertyKey())) == null) {
            heightStr = "" + this._defaultHeight;
        }
        return new Dimension(Integer.parseInt(widthStr), Integer.parseInt(heightStr));
    }

    public void setUserPreferredSize(Dimension size, boolean isMaximized) {
        Map properties = this._userPreferences.getAdditionalProperties();
        if (size != null) {
            properties.put(this.getWidthPropertyKey(), "" + size.width);
            properties.put(this.getHeightPropertyKey(), "" + size.height);
        }
        properties.put(this.getIsMaximizedWindowPropertyKey(), "" + isMaximized);
        this._userPreferences.save();
    }

    private String getHeightPropertyKey() {
        return this._identifier + "." + this._identifier + ".height";
    }

    private String getWidthPropertyKey() {
        return this._identifier + "." + this._identifier + ".width";
    }

    private String getIsMaximizedWindowPropertyKey() {
        return this._identifier + "." + this._identifier + ".maximized";
    }
}

