/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.LookAndFeelManager;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.jdesktop.swingx.HorizontalLayout;

public class ComboButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final List<AbstractButton> _buttons = new ArrayList<AbstractButton>(2);
    private final ActionListener _commonToggleButtonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AbstractButton button : ComboButton.this._buttons) {
                Object source = e.getSource();
                if (source == button) continue;
                button.setSelected(false);
            }
        }
    };

    public ComboButton() {
        super((LayoutManager)new HorizontalLayout(0));
        LineBorder border = new LineBorder(WidgetUtils.BG_COLOR_LESS_BRIGHT, 1, false);
        this.setBorder(border);
    }

    public AbstractButton addButton(String text, boolean toggleButton) {
        return this.addButton(text, (Icon)null, toggleButton);
    }

    public AbstractButton addButton(String text, Icon icon, boolean toggleButton) {
        AbstractButton button;
        if (toggleButton) {
            button = new JToggleButton(text, icon);
            button.addActionListener(this._commonToggleButtonActionListener);
        } else {
            button = new JButton(text, icon);
        }
        this.addButton(button);
        return button;
    }

    public void addButton(AbstractButton button) {
        WidgetUtils.setDefaultButtonStyle(button);
        EmptyBorder baseBorder = new EmptyBorder(3, 9, 3, 9);
        if (this.getComponentCount() == 0) {
            button.setBorder(baseBorder);
        } else {
            Component lastComponent = this.getComponent(this.getComponentCount() - 1);
            if (lastComponent instanceof AbstractButton) {
                MatteBorder outsideBorder = new MatteBorder(0, 1, 0, 0, WidgetUtils.BG_COLOR_LESS_BRIGHT);
                button.setBorder(new CompoundBorder(outsideBorder, baseBorder));
            } else {
                button.setBorder(baseBorder);
            }
        }
        button.setOpaque(false);
        this._buttons.add(button);
        this.add(button);
    }

    public JToggleButton getSelectedToggleButton() {
        for (AbstractButton button : this._buttons) {
            if (!(button instanceof JToggleButton) || !button.isSelected()) continue;
            return (JToggleButton)button;
        }
        return null;
    }

    public AbstractButton addButton(String text, String iconImagePath, boolean toggleButton) {
        ImageIcon icon = ImageManager.get().getImageIcon(iconImagePath, 22, new ClassLoader[0]);
        return this.addButton(text, icon, toggleButton);
    }

    public static void main(String[] args) {
        LookAndFeelManager.get().init();
        ComboButton comboButton1 = new ComboButton();
        comboButton1.addButton("Foo!", "images/actions/add_dark.png", true);
        comboButton1.addButton("Boo!", "images/actions/remove_dark.png", true);
        ComboButton comboButton2 = new ComboButton();
        comboButton2.addButton("Foo!", "images/actions/add_dark.png", false);
        comboButton2.addButton("Boo!", "images/actions/remove_dark.png", false);
        comboButton2.addButton("Mrr!", "images/actions/refresh.png", true);
        comboButton2.addButton("Rrrh!", "images/actions/drill-to-detail.png", true);
        DCPanel panel = new DCPanel(WidgetUtils.COLOR_DEFAULT_BACKGROUND);
        panel.add(comboButton1);
        panel.add(comboButton2);
        JButton regularButton = WidgetFactory.createDefaultButton("Regular button", "images/actions/add_dark.png");
        panel.add(regularButton);
        JFrame frame = new JFrame("test");
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 400);
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

