/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.net.URISyntaxException;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.datacleaner.util.WidgetUtils;
import org.jdesktop.swingx.action.OpenBrowserAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCHtmlBox
extends JEditorPane {
    private static final Logger logger = LoggerFactory.getLogger(DCHtmlBox.class);
    private static final long serialVersionUID = 1L;
    private static final String HTML_START_TAG = "<html>";
    private static final String HTML_END_TAG = "</html>";
    private static final String CONTENT_TYPE_HTML = "text/html";

    public DCHtmlBox(String text) {
        this.setEditorKit(JEditorPane.createEditorKitForContentType(CONTENT_TYPE_HTML));
        this.setEditable(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.setFont(WidgetUtils.FONT_NORMAL);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        new OpenBrowserAction(hyperlinkEvent.getURL()).actionPerformed(null);
                    }
                    catch (URISyntaxException e1) {
                        logger.warn("Link can not be opened. " + e1.getMessage());
                    }
                }
            }
        });
        if (text != null) {
            this.setText(text);
        }
    }

    @Override
    public void setText(String text) {
        if (text.startsWith(HTML_START_TAG) && text.endsWith(HTML_END_TAG)) {
            text = text.substring(HTML_START_TAG.length(), text.length() - HTML_END_TAG.length());
        }
        super.setText(HTML_START_TAG + this.getTableHtml(text) + HTML_END_TAG);
    }

    private String getTableHtml(String content) {
        return "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>" + content + "</td></tr></table>";
    }
}

