/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenu;
import org.datacleaner.api.ComponentCategory;
import org.datacleaner.util.IconUtils;

public class DescriptorMenu
extends JMenu
implements Comparable<DescriptorMenu> {
    private static final long serialVersionUID = 1L;
    private final ComponentCategory _componentCategory;
    private final Set<Class<?>> _componentClasses;

    public DescriptorMenu(ComponentCategory componentCategory) {
        super(componentCategory.getName());
        this._componentCategory = componentCategory;
        this._componentClasses = new HashSet();
    }

    @Override
    public Icon getIcon() {
        return IconUtils.getComponentCategoryIcon(this._componentCategory, 16);
    }

    public ComponentCategory getComponentCategory() {
        return this._componentCategory;
    }

    public DescriptorMenu addComponentClass(Class<?> clazz) {
        this._componentClasses.add(clazz);
        return this;
    }

    public DescriptorMenu addComponentClasses(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.addComponentClass(clazz);
        }
        return this;
    }

    public int getComponentClassCount() {
        return this._componentClasses.size();
    }

    public boolean containsComponentClass(Class<?> clazz) {
        return this._componentClasses.contains(clazz);
    }

    @Override
    public int compareTo(DescriptorMenu o) {
        int diff = this.getText().compareTo(o.getText());
        if (diff == 0) {
            if (this.getComponentCategory().equals(o.getComponentCategory())) {
                return 0;
            }
            return -1;
        }
        return diff;
    }
}

