/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.metamodel.util.Action;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.configuration.DataCleanerEnvironment;
import org.datacleaner.configuration.DataCleanerEnvironmentImpl;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.AnalyzerComponentBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.concurrent.SingleThreadedTaskRunner;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.util.PreviewUtils;
import org.datacleaner.util.SourceColumnFinder;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.windows.AnalysisJobBuilderWindow;

public class ExecuteButtonOptions {
    private static final List<ExecutionMenuItem> MENU_ITEMS = new ArrayList<ExecutionMenuItem>();

    public static void addMenuItem(ExecutionMenuItem menuItem) {
        MENU_ITEMS.add(menuItem);
    }

    public static void addMenuItem(int index, ExecutionMenuItem menuItem) {
        MENU_ITEMS.add(index, menuItem);
    }

    public static void removeMenuItem(ExecutionMenuItem menuItem) {
        MENU_ITEMS.remove(menuItem);
    }

    public static void removeMenuItem(int index) {
        MENU_ITEMS.remove(index);
    }

    public static List<ExecutionMenuItem> getMenuItems() {
        return Collections.unmodifiableList(MENU_ITEMS);
    }

    private ExecuteButtonOptions() {
    }

    static {
        ExecuteButtonOptions.addMenuItem(new SimpleExecutionMenuItem("Run normally", "images/menu/execute.png"){

            @Override
            protected void run(AnalysisJobBuilder analysisJobBuilder, Action<AnalysisJobBuilder> executeAction, AnalysisJobBuilderWindow analysisJobBuilderWindow) throws Exception {
                executeAction.run((Object)analysisJobBuilder);
            }
        });
        ExecuteButtonOptions.addMenuItem(new SimpleExecutionMenuItem("Run first N records", "images/actions/preview_data.png"){

            @Override
            protected void run(AnalysisJobBuilder analysisJobBuilder, Action<AnalysisJobBuilder> executeAction, AnalysisJobBuilderWindow analysisJobBuilderWindow) throws Exception {
                Integer maxRows = WidgetFactory.showMaxRowsDialog(100);
                if (maxRows != null) {
                    AnalysisJob jobCopy = analysisJobBuilder.toAnalysisJob(false);
                    AnalysisJobBuilder jobBuilderCopy = new AnalysisJobBuilder(analysisJobBuilder.getConfiguration(), jobCopy);
                    Set analyzers = jobBuilderCopy.getComponentBuilders().stream().filter(o -> o instanceof AnalyzerComponentBuilder).collect(Collectors.toSet());
                    SourceColumnFinder scf = new SourceColumnFinder();
                    scf.addSources(jobBuilderCopy);
                    Set filtered = analyzers.stream().filter(acb -> PreviewUtils.hasFilterPresent((SourceColumnFinder)scf, (ComponentBuilder)acb)).collect(Collectors.toSet());
                    if (filtered.size() == 0) {
                        PreviewUtils.limitJobRows((AnalysisJobBuilder)jobBuilderCopy, (Collection)jobBuilderCopy.getComponentBuilders(), (int)maxRows);
                    } else {
                        PreviewUtils.limitJobRows((AnalysisJobBuilder)jobBuilderCopy, (Collection)jobBuilderCopy.getFilterComponentBuilders(), (int)maxRows);
                        Set unfilteredAnalyzers = analyzers.stream().filter(acb -> !PreviewUtils.hasFilterPresent((SourceColumnFinder)scf, (ComponentBuilder)acb)).collect(Collectors.toSet());
                        PreviewUtils.limitJobRows((AnalysisJobBuilder)jobBuilderCopy, unfilteredAnalyzers, (int)maxRows);
                    }
                    executeAction.run((Object)jobBuilderCopy);
                }
            }
        });
        ExecuteButtonOptions.addMenuItem(new SimpleExecutionMenuItem("Run single-threaded", "images/model/row.png"){

            @Override
            protected void run(AnalysisJobBuilder analysisJobBuilder, Action<AnalysisJobBuilder> executeAction, AnalysisJobBuilderWindow analysisJobBuilderWindow) throws Exception {
                DataCleanerConfiguration baseConfiguration = analysisJobBuilder.getConfiguration();
                DataCleanerConfigurationImpl configuration = new DataCleanerConfigurationImpl(baseConfiguration).withEnvironment((DataCleanerEnvironment)new DataCleanerEnvironmentImpl(baseConfiguration.getEnvironment()).withTaskRunner((TaskRunner)new SingleThreadedTaskRunner()));
                AnalysisJob jobCopy = analysisJobBuilder.toAnalysisJob(false);
                AnalysisJobBuilder jobBuilderCopy = new AnalysisJobBuilder((DataCleanerConfiguration)configuration, jobCopy);
                executeAction.run((Object)jobBuilderCopy);
            }
        });
    }

    public static class Separator
    implements ExecutionMenuItem {
        @Override
        public String getText() {
            return null;
        }

        @Override
        public String getIconPath() {
            return null;
        }

        @Override
        public ActionListener createActionListener(AnalysisJobBuilder analysisJobBuilder, Action<AnalysisJobBuilder> executeAction, AnalysisJobBuilderWindow analysisJobBuilderWindow) {
            return null;
        }
    }

    private static abstract class SimpleExecutionMenuItem
    implements ExecutionMenuItem {
        private final String _text;
        private final String _iconPath;

        public SimpleExecutionMenuItem(String text, String iconPath) {
            this._text = text;
            this._iconPath = iconPath;
        }

        @Override
        public final String getIconPath() {
            return this._iconPath;
        }

        @Override
        public final String getText() {
            return this._text;
        }

        @Override
        public final ActionListener createActionListener(AnalysisJobBuilder analysisJobBuilder, Action<AnalysisJobBuilder> executeAction, AnalysisJobBuilderWindow analysisJobBuilderWindow) {
            return event -> {
                try {
                    this.run(analysisJobBuilder, executeAction, analysisJobBuilderWindow);
                }
                catch (Exception e) {
                    WidgetUtils.showErrorMessage("Unexpected error", "An error occurred while executing job in mode '" + this.getText() + "'", e);
                }
            };
        }

        protected abstract void run(AnalysisJobBuilder var1, Action<AnalysisJobBuilder> var2, AnalysisJobBuilderWindow var3) throws Exception;
    }

    public static interface ExecutionMenuItem {
        public String getText();

        public String getIconPath();

        public ActionListener createActionListener(AnalysisJobBuilder var1, Action<AnalysisJobBuilder> var2, AnalysisJobBuilderWindow var3);
    }
}

