/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.widgets.properties.PropertyWidget;
import org.datacleaner.widgets.properties.PropertyWidgetMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyWidgetCollection {
    private static final Logger logger = LoggerFactory.getLogger(PropertyWidgetCollection.class);
    private final ComponentBuilder _componentBuilder;
    private final Map<ConfiguredPropertyDescriptor, PropertyWidget<?>> _widgets;
    private final Map<ConfiguredPropertyDescriptor, PropertyWidgetMapping> _propertyWidgetMappings;

    public PropertyWidgetCollection(ComponentBuilder componentBuilder) {
        this._componentBuilder = componentBuilder;
        this._widgets = new HashMap();
        this._propertyWidgetMappings = new IdentityHashMap<ConfiguredPropertyDescriptor, PropertyWidgetMapping>();
        logger.debug("id={} - init", (Object)System.identityHashCode(this));
    }

    public Collection<PropertyWidget<?>> getWidgets() {
        return this._widgets.values();
    }

    public PropertyWidget<?> getWidget(ConfiguredPropertyDescriptor propertyDescriptor) {
        return this._widgets.get(propertyDescriptor);
    }

    public void putMappedPropertyWidget(ConfiguredPropertyDescriptor mappedProperty, PropertyWidgetMapping propertyWidgetMapping) {
        this._propertyWidgetMappings.put(mappedProperty, propertyWidgetMapping);
    }

    public PropertyWidget<?> getMappedPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor) {
        PropertyWidget<?> propertyWidget;
        PropertyWidgetMapping existingMapping = this._propertyWidgetMappings.get(propertyDescriptor);
        if (existingMapping != null && (propertyWidget = existingMapping.getMapping(propertyDescriptor)) != null) {
            return propertyWidget;
        }
        return null;
    }

    public void registerWidget(ConfiguredPropertyDescriptor propertyDescriptor, PropertyWidget<?> widget) {
        if (widget == null) {
            this._widgets.remove(propertyDescriptor);
        } else {
            this._widgets.put(propertyDescriptor, widget);
            PropertyWidget<?> objectWidget = widget;
            Object value = this._componentBuilder.getConfiguredProperty(objectWidget.getPropertyDescriptor());
            objectWidget.initialize(value);
        }
    }

    public void onConfigurationChanged() {
        Collection<PropertyWidget<?>> widgets = this.getWidgets();
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("id=");
            sb.append(System.identityHashCode(this));
            sb.append(" - onConfigurationChanged() - notifying widgets:");
            sb.append(widgets.size());
            for (PropertyWidget<?> widget : widgets) {
                String propertyName = widget.getPropertyDescriptor().getName();
                String propertyWidgetClassName = widget.getClass().getSimpleName();
                sb.append("\n - ");
                sb.append(propertyName);
                sb.append(": ");
                sb.append(propertyWidgetClassName);
            }
            logger.debug(sb.toString());
        }
        Iterator<PropertyWidget<?>> iterator = widgets.iterator();
        while (iterator.hasNext()) {
            PropertyWidget<?> widget;
            PropertyWidget<?> objectWidget = widget = iterator.next();
            ConfiguredPropertyDescriptor propertyDescriptor = objectWidget.getPropertyDescriptor();
            Object value = this._componentBuilder.getConfiguredProperty(propertyDescriptor);
            objectWidget.onValueTouched(value);
        }
    }
}

