/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.widgets.visualization;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.LabelUtils;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.visualization.ComponentScopeMenuBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentScopeButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ComponentScopeButton.class);
    private static final ImageManager imageManager = ImageManager.get();
    private static final Icon scopeIcon = imageManager.getImageIcon("images/component-types/output-data-stream.png", 22, new ClassLoader[0]);
    private final ComponentBuilder _componentBuilder;
    private final AnalysisJobBuilder _topLevelJobBuilder;
    private final ComponentScopeMenuBuilder _menuBuilder;

    public ComponentScopeButton(ComponentBuilder componentBuilder, ComponentScopeMenuBuilder menuBuilder) {
        super("(No requirement)", scopeIcon);
        this._componentBuilder = componentBuilder;
        this._menuBuilder = menuBuilder;
        this._topLevelJobBuilder = componentBuilder.getAnalysisJobBuilder().getRootJobBuilder();
        this.addActionListener(this);
        this.updateText(this._componentBuilder.getAnalysisJobBuilder(), this._menuBuilder.findComponentBuilder(this._componentBuilder.getAnalysisJobBuilder()));
        WidgetUtils.setDefaultButtonStyle(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPopupMenu popup = new JPopupMenu();
        List<JMenuItem> menuItems = this._menuBuilder.createMenuItems();
        for (JMenuItem menuItem : menuItems) {
            popup.add(menuItem);
        }
        popup.show(this, 0, this.getHeight());
    }

    public void updateText(final AnalysisJobBuilder osJobBuilder, final ComponentBuilder osComponentBuilder) {
        logger.debug("updateText()");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (osJobBuilder == ComponentScopeButton.this._topLevelJobBuilder) {
                    ComponentScopeButton.this.setText("Default scope");
                } else {
                    ComponentScopeButton.this.setText(LabelUtils.getLabel((ComponentBuilder)osComponentBuilder) + ": " + osJobBuilder.getDatastore().getName());
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception e) {
            logger.error("Failed to update ComponentScopeButton", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "ComponentScopeMenuBuilder[componentBuilder=" + LabelUtils.getLabel((ComponentBuilder)this._componentBuilder) + "]";
    }

    public boolean isRelevant() {
        if (this._componentBuilder.getDescriptor().isMultiStreamComponent()) {
            return false;
        }
        return this._menuBuilder.getComponentBuildersWithOutputDataStreams(this._topLevelJobBuilder).size() > 0;
    }
}

