/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.Properties;
import org.apache.metamodel.util.FileHelper;

public class Version {
    private static final String VERSION = Version.determineVersion();
    private static final String EDITION = Version.determineEdition();
    public static final String EDITION_COMMUNITY = "Community edition";
    public static final String EDITION_PROFESSIONAL = "Professional edition";

    @Deprecated
    public static String get() {
        return Version.getVersion();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getEdition() {
        return EDITION;
    }

    public static String getLicenseKey() {
        return System.getProperty("datacleaner.license.key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String determineVersion() {
        Properties properties = new Properties();
        InputStream inputStream = Version.class.getResourceAsStream("/META-INF/maven/org.eobjects.datacleaner/DataCleaner-api/pom.properties");
        try {
            properties.load(inputStream);
        }
        catch (Exception e) {
            String string;
            try {
                System.err.println("Failed to load DataCleaner version from manifest: " + e.getMessage());
                string = "UNKNOWN";
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            return string;
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        String version = properties.getProperty("version");
        return version;
    }

    private static String determineEdition() {
        String systemProperty = System.getProperty("datacleaner.edition.name");
        if (!Strings.isNullOrEmpty((String)systemProperty)) {
            return systemProperty;
        }
        Properties properties = new Properties();
        InputStream inputStream = Version.class.getResourceAsStream("/META-INF/maven/com.hi.datacleaner/DataCleaner-enterprise-edition-core-components/pom.properties");
        try {
            properties.load(inputStream);
        }
        catch (Exception e) {
            return EDITION_COMMUNITY;
        }
        String version = properties.getProperty("version");
        if (Strings.isNullOrEmpty((String)version)) {
            return EDITION_COMMUNITY;
        }
        return EDITION_PROFESSIONAL;
    }

    public static boolean isCommunityEdition() {
        return Version.getEdition() == EDITION_COMMUNITY;
    }

    static {
        System.out.println("DataCleaner " + EDITION + " version: " + VERSION);
    }
}

