/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.tablelookup;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.CompiledQuery;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.QueryParameter;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Close;
import org.datacleaner.api.ColumnProperty;
import org.datacleaner.api.Concurrent;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.HasLabelAdvice;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.MappedProperty;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.api.Provided;
import org.datacleaner.api.SchemaProperty;
import org.datacleaner.api.TableProperty;
import org.datacleaner.api.Transformer;
import org.datacleaner.api.Validate;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.util.CollectionUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="Table lookup")
@Alias(value={"Datastore lookup"})
@Description(value="Perform a lookup based on a table in any of your registered datastore (like a LEFT join).")
@Concurrent(value=true)
public class TableLookupTransformer
implements Transformer,
HasLabelAdvice {
    private static final Logger logger = LoggerFactory.getLogger(TableLookupTransformer.class);
    private static final String PROPERTY_NAME_DATASTORE = "Datastore";
    private static final String PROPERTY_NAME_SCHEMA_NAME = "Schema name";
    private static final String PROPERTY_NAME_TABLE_NAME = "Table name";
    @Inject
    @Configured(value="Datastore")
    Datastore datastore;
    @Inject
    @Configured(required=false)
    InputColumn<?>[] conditionValues;
    @Inject
    @Configured(required=false)
    @ColumnProperty
    @MappedProperty(value="Table name")
    String[] conditionColumns;
    @Inject
    @Configured
    @ColumnProperty
    @MappedProperty(value="Table name")
    String[] outputColumns;
    @Inject
    @Configured(value="Schema name")
    @Alias(value={"Schema"})
    @SchemaProperty
    @MappedProperty(value="Datastore")
    String schemaName;
    @Inject
    @Configured(value="Table name")
    @Alias(value={"Table"})
    @TableProperty
    @MappedProperty(value="Schema name")
    String tableName;
    @Inject
    @Configured
    @Description(value="Use a client-side cache to avoid looking up multiple times with same inputs.")
    boolean cacheLookups = true;
    @Inject
    @Configured
    @Description(value="Which kind of semantic to apply to the lookup, compared to a SQL JOIN.")
    JoinSemantic joinSemantic = JoinSemantic.LEFT_JOIN_MAX_ONE;
    @Inject
    @Provided
    OutputRowCollector outputRowCollector;
    private final Cache<List<Object>, Object[]> cache = CollectionUtils2.createCache(10000, 300L);
    private Column[] queryOutputColumns;
    private Column[] queryConditionColumns;
    private DatastoreConnection datastoreConnection;
    private CompiledQuery lookupQuery;

    public TableLookupTransformer() {
    }

    public TableLookupTransformer(Datastore datastore, String schemaName, String tableName, String[] conditionColumns, InputColumn<?>[] conditionValues, String[] outputColumns, boolean cacheLookups) {
        this.datastore = datastore;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.conditionColumns = conditionColumns;
        this.conditionValues = conditionValues;
        this.cacheLookups = cacheLookups;
        this.outputColumns = outputColumns;
        this.joinSemantic = JoinSemantic.LEFT_JOIN_MAX_ONE;
    }

    public String getSuggestedLabel() {
        if (this.tableName == null) {
            return null;
        }
        return "Lookup: " + this.tableName;
    }

    private void resetCachedColumns() {
        this.queryOutputColumns = null;
        this.queryConditionColumns = null;
    }

    private Column[] getQueryConditionColumns() {
        if (this.queryConditionColumns == null) {
            if (this.isCarthesianProductMode()) {
                this.queryConditionColumns = new Column[0];
            } else {
                try (DatastoreConnection con = this.datastore.openConnection();){
                    this.queryConditionColumns = con.getSchemaNavigator().convertToColumns(this.schemaName, this.tableName, this.conditionColumns);
                }
            }
        }
        return this.queryConditionColumns;
    }

    private Column[] getQueryOutputColumns(boolean checkNames) {
        if (this.queryOutputColumns == null) {
            try (DatastoreConnection con = this.datastore.openConnection();){
                this.queryOutputColumns = con.getSchemaNavigator().convertToColumns(this.schemaName, this.tableName, this.outputColumns);
            }
        } else if (checkNames && !this.isQueryOutputColumnsUpdated()) {
            this.queryOutputColumns = null;
            return this.getQueryOutputColumns(false);
        }
        return this.queryOutputColumns;
    }

    private boolean isQueryOutputColumnsUpdated() {
        if (this.queryOutputColumns.length != this.outputColumns.length) {
            return false;
        }
        for (int i = 0; i < this.queryOutputColumns.length; ++i) {
            String expectedName = this.outputColumns[i];
            Column outputColumn = this.queryOutputColumns[i];
            if (!expectedName.equals(outputColumn.getName())) {
                return false;
            }
            if (this.tableName == null || this.tableName.equals(outputColumn.getTable().getName())) continue;
            return false;
        }
        return true;
    }

    @Initialize
    public void init() {
        this.datastoreConnection = this.datastore.openConnection();
        this.resetCachedColumns();
        this.cache.invalidateAll();
        this.compileLookupQuery();
    }

    private void compileLookupQuery() {
        try {
            Column[] queryOutputColumns = this.getQueryOutputColumns(false);
            Column queryOutputColumn = queryOutputColumns[0];
            Table table = queryOutputColumn.getTable();
            Query query = new Query().from(table).select(queryOutputColumns);
            if (!this.isCarthesianProductMode()) {
                Column[] queryConditionColumns = this.getQueryConditionColumns();
                for (int i = 0; i < queryConditionColumns.length; ++i) {
                    query = query.where(queryConditionColumns[i], OperatorType.EQUALS_TO, (Object)new QueryParameter());
                }
            }
            if (this.joinSemantic == JoinSemantic.LEFT_JOIN_MAX_ONE) {
                query = query.setMaxRows(Integer.valueOf(1));
            }
            this.lookupQuery = this.datastoreConnection.getDataContext().compileQuery(query);
        }
        catch (RuntimeException e) {
            logger.error("Error occurred while compiling lookup query", (Throwable)e);
            throw e;
        }
    }

    private boolean isCarthesianProductMode() {
        return !(this.conditionColumns != null && this.conditionColumns.length != 0 || this.conditionValues != null && this.conditionValues.length != 0);
    }

    @Validate
    public void validate() {
        if (this.isCarthesianProductMode()) {
            return;
        }
        Column[] queryConditionColumns = this.getQueryConditionColumns();
        ArrayList<String> columnsNotFound = new ArrayList<String>();
        for (int i = 0; i < queryConditionColumns.length; ++i) {
            if (queryConditionColumns[i] != null) continue;
            columnsNotFound.add(this.conditionColumns[i]);
        }
        if (!columnsNotFound.isEmpty()) {
            throw new IllegalArgumentException("Could not find column(s): " + columnsNotFound);
        }
    }

    public OutputColumns getOutputColumns() {
        Column[] queryOutputColumns = this.getQueryOutputColumns(true);
        String[] names = new String[queryOutputColumns.length];
        Class[] types = new Class[queryOutputColumns.length];
        for (int i = 0; i < queryOutputColumns.length; ++i) {
            Column column = queryOutputColumns[i];
            if (column == null) {
                throw new IllegalArgumentException("Could not find column: " + this.outputColumns[i]);
            }
            names[i] = column.getName() + " (lookup)";
            types[i] = column.getType().getJavaEquivalentClass();
        }
        return new OutputColumns(names, types);
    }

    public Object[] transform(InputRow inputRow) {
        Object[] result;
        List<Object> queryInput;
        if (this.isCarthesianProductMode()) {
            queryInput = Collections.emptyList();
        } else {
            queryInput = new ArrayList(this.conditionValues.length);
            for (InputColumn<?> inputColumn : this.conditionValues) {
                Object value = inputRow.getValue(inputColumn);
                queryInput.add(value);
            }
        }
        logger.info("Looking up based on condition values: {}", queryInput);
        if (this.cacheLookups && this.joinSemantic.isCacheable()) {
            result = (Object[])this.cache.getIfPresent(queryInput);
            if (result == null) {
                result = this.performQuery(queryInput);
                this.cache.put(queryInput, (Object)result);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Returning cached lookup result: {}", (Object)Arrays.toString(result));
            }
        } else {
            result = this.performQuery(queryInput);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] performQuery(List<Object> queryInput) {
        try {
            Column[] queryConditionColumns = this.getQueryConditionColumns();
            Object[] parameterValues = new Object[queryConditionColumns.length];
            for (int i = 0; i < queryConditionColumns.length; ++i) {
                parameterValues[i] = queryInput.get(i);
            }
            try (DataSet dataSet = this.datastoreConnection.getDataContext().executeQuery(this.lookupQuery, parameterValues);){
                Object[] objectArray = this.handleDataSet(dataSet);
                return objectArray;
            }
        }
        catch (RuntimeException e) {
            logger.error("Error occurred while looking up based on conditions: " + queryInput, (Throwable)e);
            throw e;
        }
    }

    private Object[] handleDataSet(DataSet dataSet) {
        if (!dataSet.next()) {
            logger.info("Result of lookup: None!");
            switch (this.joinSemantic) {
                case LEFT_JOIN_MAX_ONE: 
                case LEFT_JOIN: {
                    return new Object[this.outputColumns.length];
                }
            }
            return null;
        }
        do {
            Object[] result = dataSet.getRow().getValues();
            if (logger.isInfoEnabled()) {
                logger.info("Result of lookup: " + Arrays.toString(result));
            }
            switch (this.joinSemantic) {
                case LEFT_JOIN_MAX_ONE: {
                    return result;
                }
            }
            this.outputRowCollector.putValues(result);
        } while (dataSet.next());
        return null;
    }

    @Close
    public void close() {
        if (this.lookupQuery != null) {
            this.lookupQuery.close();
            this.lookupQuery = null;
        }
        if (this.datastore != null) {
            this.datastoreConnection.close();
            this.datastoreConnection = null;
        }
        this.cache.invalidateAll();
        this.queryOutputColumns = null;
        this.queryConditionColumns = null;
    }

    public static enum JoinSemantic implements HasName
    {
        LEFT_JOIN_MAX_ONE("Left join (max 1 record)"),
        INNER_JOIN("Inner join"),
        LEFT_JOIN("Left join");

        private final String _name;

        private JoinSemantic(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public boolean isCacheable() {
            return this == LEFT_JOIN_MAX_ONE;
        }
    }
}

