/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import org.datacleaner.api.ComponentContext;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.configuration.InjectionPoint;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.ComponentContextImpl;

public class ContextAwareInjectionManager
implements InjectionManager {
    private final InjectionManager _delegate;
    private final ComponentJob _componentJob;
    private final AnalysisListener _listener;
    private final AnalysisJob _job;

    public ContextAwareInjectionManager(InjectionManager delegate, AnalysisJob job, ComponentJob componentJob, AnalysisListener listener) {
        this._delegate = delegate;
        this._job = job;
        this._componentJob = componentJob;
        this._listener = listener;
    }

    @Override
    public <E> E getInstance(InjectionPoint<E> injectionPoint) {
        Class<E> baseType = injectionPoint.getBaseType();
        if (baseType == ComponentContext.class) {
            ComponentContextImpl componentContext = new ComponentContextImpl(this._job, this._componentJob, this._listener);
            return (E)componentContext;
        }
        return this._delegate.getInstance(injectionPoint);
    }
}

