/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.datacleaner.configuration.AnalyzerBeansConfigurationImpl;
import org.datacleaner.configuration.ConfigurationReaderInterceptor;
import org.datacleaner.util.convert.ClasspathResourceTypeHandler;
import org.datacleaner.util.convert.FileResourceTypeHandler;
import org.datacleaner.util.convert.ResourceConverter;
import org.datacleaner.util.convert.UrlResourceTypeHandler;
import org.datacleaner.util.convert.VfsResourceTypeHandler;

public class DefaultConfigurationReaderInterceptor
implements ConfigurationReaderInterceptor {
    @Override
    public String createFilename(String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return filename;
        }
        File relativeParentDirectory = this.getRelativeParentDirectory();
        if (relativeParentDirectory == null) {
            return filename;
        }
        return new File(relativeParentDirectory, filename).getPath();
    }

    @Override
    public Resource createResource(String resourceUrl) {
        ResourceConverter converter = new ResourceConverter(this.getResourceTypeHandlers(), "file");
        Resource resource = converter.fromString(Resource.class, resourceUrl);
        return resource;
    }

    protected List<ResourceConverter.ResourceTypeHandler<?>> getResourceTypeHandlers() {
        ArrayList handlers = new ArrayList();
        handlers.add(new FileResourceTypeHandler(this.getRelativeParentDirectory()));
        handlers.add(new UrlResourceTypeHandler());
        handlers.add(new ClasspathResourceTypeHandler());
        handlers.add(new VfsResourceTypeHandler());
        return handlers;
    }

    protected File getRelativeParentDirectory() {
        return null;
    }

    @Override
    public String getTemporaryStorageDirectory() {
        return FileHelper.getTempDir().getAbsolutePath();
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    @Override
    public String getPropertyOverride(String variablePath) {
        String result = System.getProperty(variablePath);
        return result;
    }

    @Override
    public AnalyzerBeansConfigurationImpl createBaseConfiguration() {
        return new AnalyzerBeansConfigurationImpl();
    }
}

