/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import com.datastax.driver.core.Cluster;
import java.io.Closeable;
import org.apache.metamodel.cassandra.CassandraDataContext;
import org.apache.metamodel.util.SimpleTableDef;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;

public class CassandraDatastore
extends UsageAwareDatastore<CassandraDataContext> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PORT = 9042;
    private final String _keyspace;
    private final SimpleTableDef[] _tableDefs;
    private final String _hostname;
    private final int _port;
    private final String _username;
    private final String _password;
    private final boolean _ssl;

    public CassandraDatastore(String name, String hostname, String keyspace) {
        this(name, hostname, 9042, keyspace);
    }

    public CassandraDatastore(String name, String hostname, int port, String keyspace) {
        this(name, hostname, port, keyspace, null, null, false, null);
    }

    public CassandraDatastore(String name, String hostname, int port, String keyspace, String username, String password, boolean ssl, SimpleTableDef[] tableDefs) {
        super(name);
        this._hostname = hostname;
        this._port = port;
        this._keyspace = keyspace;
        this._username = username;
        this._password = password;
        this._ssl = ssl;
        this._tableDefs = tableDefs;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected UsageAwareDatastoreConnection<CassandraDataContext> createDatastoreConnection() {
        Cluster.Builder clusterBuilder = Cluster.builder();
        clusterBuilder = clusterBuilder.addContactPoint(this._hostname);
        clusterBuilder = clusterBuilder.withPort(this._port);
        if (this._ssl) {
            clusterBuilder = clusterBuilder.withSSL();
        }
        if (this._username != null && this._password != null) {
            clusterBuilder = clusterBuilder.withCredentials(this._username, this._password);
        }
        Cluster cluster = clusterBuilder.build();
        CassandraDataContext dataContext = this._tableDefs == null || this._tableDefs.length == 0 ? new CassandraDataContext(cluster, this._keyspace) : new CassandraDataContext(cluster, this._keyspace, this._tableDefs);
        return new DatastoreConnectionImpl<CassandraDataContext>(dataContext, this, new Closeable[0]);
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public String getKeyspace() {
        return this._keyspace;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public SimpleTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    public boolean isSsl() {
        return this._ssl;
    }

    @Override
    public String toString() {
        return "CassandraDatastore[name=" + this.getName() + "]";
    }
}

