/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.Closeable;
import java.util.List;
import org.apache.metamodel.couchdb.CouchDbDataContext;
import org.apache.metamodel.util.SimpleTableDef;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.connection.UsernameDatastore;
import org.ektorp.http.StdHttpClient;

public class CouchDbDatastore
extends UsageAwareDatastore<CouchDbDataContext>
implements UpdateableDatastore,
UsernameDatastore {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PORT = 5984;
    private static final int HTTP_TIMEOUT = 20000;
    private final String _hostname;
    private final Integer _port;
    private final String _username;
    private final String _password;
    private final boolean _sslEnabled;
    private final SimpleTableDef[] _tableDefs;

    public CouchDbDatastore(String name, String hostname, Integer port, String username, String password, boolean sslEnabled, SimpleTableDef[] tableDefs) {
        super(name);
        this._hostname = hostname;
        this._port = port;
        this._username = username;
        this._password = password;
        this._sslEnabled = sslEnabled;
        this._tableDefs = tableDefs;
    }

    public UpdateableDatastoreConnection openConnection() {
        return (UpdateableDatastoreConnection)super.openConnection();
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected UsageAwareDatastoreConnection<CouchDbDataContext> createDatastoreConnection() {
        StdHttpClient.Builder httpClient = new StdHttpClient.Builder();
        httpClient.host(this.getHostname());
        if (this._port != null) {
            httpClient.port(this._port.intValue());
        }
        if (this._username != null) {
            httpClient.username(this._username);
        }
        if (this._password != null) {
            httpClient.password(this._password);
        }
        httpClient.enableSSL(this._sslEnabled);
        httpClient.connectionTimeout(20000);
        httpClient.socketTimeout(20000);
        CouchDbDataContext dataContext = this._tableDefs != null && this._tableDefs.length > 0 ? new CouchDbDataContext(httpClient, this._tableDefs) : new CouchDbDataContext(httpClient);
        return new UpdateableDatastoreConnectionImpl<CouchDbDataContext>(dataContext, this, new Closeable[0]);
    }

    public String getHostname() {
        if (this._hostname == null) {
            return "localhost";
        }
        return this._hostname;
    }

    public int getPort() {
        if (this._port == null) {
            return 5984;
        }
        return this._port;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public SimpleTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    public boolean isSslEnabled() {
        return this._sslEnabled;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._hostname);
        identifiers.add(this.getPort());
        identifiers.add(this._username);
        identifiers.add(this._password);
        identifiers.add(this._sslEnabled);
        identifiers.add(this._tableDefs);
    }
}

