/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.metamodel.DataContext;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.SchemaNavigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreConnectionLease
implements DatastoreConnection {
    private static final Logger logger = LoggerFactory.getLogger(DatastoreConnectionLease.class);
    private final DatastoreConnection _delegate;
    private final AtomicBoolean _closed;

    public DatastoreConnectionLease(DatastoreConnection delegate) {
        this._delegate = delegate;
        this._closed = new AtomicBoolean(false);
    }

    public DatastoreConnection getDelegate() {
        return this._delegate;
    }

    public boolean isClosed() {
        return this._closed.get();
    }

    public DataContext getDataContext() {
        return this._delegate.getDataContext();
    }

    public SchemaNavigator getSchemaNavigator() {
        return this._delegate.getSchemaNavigator();
    }

    public Datastore getDatastore() {
        return this._delegate.getDatastore();
    }

    public void close() {
        boolean changed = this._closed.compareAndSet(false, true);
        if (changed) {
            this._delegate.close();
        } else {
            logger.warn("Connection is already closed, but close() was invoked!", new Throwable());
        }
    }

    public String toString() {
        return "DatastoreConnectionLease[" + this._delegate + "]";
    }
}

