/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.Closeable;
import org.apache.metamodel.elasticsearch.ElasticSearchDataContext;
import org.apache.metamodel.util.SimpleTableDef;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ElasticSearchDatastore
extends UsageAwareDatastore<ElasticSearchDataContext> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PORT = 9300;
    private final SimpleTableDef[] _tableDefs;
    private final String _indexName;
    private final String _hostname;
    private final int _port;
    private final String _clusterName;

    public ElasticSearchDatastore(String name, String hostname, int port, String clusterName, String indexName) {
        this(name, hostname, port, clusterName, indexName, null);
    }

    public ElasticSearchDatastore(String name, String hostname, int port, String clusterName, String indexName, SimpleTableDef[] tableDefs) {
        super(name);
        this._hostname = hostname;
        this._port = port;
        this._clusterName = clusterName;
        this._indexName = indexName;
        this._tableDefs = tableDefs;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected UsageAwareDatastoreConnection<ElasticSearchDataContext> createDatastoreConnection() {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.builder();
        settingsBuilder.put("name", "AnalyzerBeans");
        settingsBuilder.put("cluster.name", this._clusterName);
        Settings settings = settingsBuilder.build();
        TransportClient client = new TransportClient(settings);
        client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(this._hostname, this._port));
        ElasticSearchDataContext dataContext = this._tableDefs == null || this._tableDefs.length == 0 ? new ElasticSearchDataContext((Client)client, this._indexName) : new ElasticSearchDataContext((Client)client, this._indexName, this._tableDefs);
        return new DatastoreConnectionImpl<ElasticSearchDataContext>(dataContext, this, new Closeable[0]);
    }

    public SimpleTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public String getIndexName() {
        return this._indexName;
    }

    @Override
    public String toString() {
        return "ElasticSearchDatastore[name=" + this.getName() + "]";
    }
}

