/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.Closeable;
import java.util.List;
import org.apache.metamodel.hbase.HBaseConfiguration;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.SimpleTableDef;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;

public class HBaseDatastore
extends UsageAwareDatastore<HBaseDataContext> {
    private static final long serialVersionUID = 1L;
    private final int _zookeeperPort;
    private final String _zookeeperHostname;
    private final SimpleTableDef[] _tableDefs;

    public HBaseDatastore(String name, String zookeeperHostname, int zookeeperPort) {
        this(name, zookeeperHostname, zookeeperPort, null);
    }

    public HBaseDatastore(String name, String zookeeperHostname, int zookeeperPort, SimpleTableDef[] tableDefs) {
        super(name);
        this._zookeeperHostname = zookeeperHostname;
        this._zookeeperPort = zookeeperPort;
        this._tableDefs = tableDefs;
    }

    @Override
    public DatastoreConnection openConnection() {
        return super.openConnection();
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected UsageAwareDatastoreConnection<HBaseDataContext> createDatastoreConnection() {
        HBaseConfiguration hBaseConfiguration = new HBaseConfiguration("HBase", this._zookeeperHostname, this._zookeeperPort, this._tableDefs, ColumnType.STRING);
        HBaseDataContext hBaseDataContext = new HBaseDataContext(hBaseConfiguration);
        DatastoreConnectionImpl<HBaseDataContext> connection = new DatastoreConnectionImpl<HBaseDataContext>(hBaseDataContext, this, new Closeable[0]);
        return connection;
    }

    public String getZookeeperHostname() {
        return this._zookeeperHostname;
    }

    public int getZookeeperPort() {
        return this._zookeeperPort;
    }

    public SimpleTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._zookeeperHostname);
        identifiers.add(this._zookeeperPort);
        identifiers.add(this._tableDefs);
    }
}

