/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import com.mongodb.DB;
import com.mongodb.Mongo;
import java.io.Closeable;
import java.util.List;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.mongodb.MongoDbDataContext;
import org.apache.metamodel.util.SimpleTableDef;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.connection.UsernameDatastore;
import org.datacleaner.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbDatastore
extends UsageAwareDatastore<UpdateableDataContext>
implements UpdateableDatastore,
UsernameDatastore {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDatastore.class);
    private final String _hostname;
    private final int _port;
    private final String _databaseName;
    private final String _username;
    private final char[] _password;
    private final SimpleTableDef[] _tableDefs;

    public MongoDbDatastore(String name, String databaseName) {
        this(name, null, null, databaseName);
    }

    public MongoDbDatastore(String name, String hostname, Integer port, String databaseName) {
        this(name, hostname, port, databaseName, null, (char[])null);
    }

    public MongoDbDatastore(String name, String hostname, Integer port, String databaseName, String username, String password) {
        this(name, hostname, port, databaseName, username, password == null ? null : password.toCharArray());
    }

    public MongoDbDatastore(String name, String hostname, Integer port, String databaseName, String username, char[] password) {
        this(name, hostname, port, databaseName, username, password, null);
    }

    public MongoDbDatastore(String name, String hostname, Integer port, String databaseName, String username, String password, SimpleTableDef[] tableDefs) {
        this(name, hostname, port, databaseName, username, password == null ? null : password.toCharArray(), tableDefs);
    }

    public MongoDbDatastore(String name, String hostname, Integer port, String databaseName, String username, char[] password, SimpleTableDef[] tableDefs) {
        super(name);
        if (StringUtils.isNullOrEmpty(databaseName)) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        if (StringUtils.isNullOrEmpty(hostname)) {
            hostname = "localhost";
        }
        if (port == null) {
            port = 27017;
        }
        this._hostname = hostname;
        this._port = port;
        this._databaseName = databaseName;
        this._username = username;
        this._password = password;
        this._tableDefs = tableDefs;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected UsageAwareDatastoreConnection<UpdateableDataContext> createDatastoreConnection() {
        try {
            boolean authenticated;
            Mongo mongo = new Mongo(this._hostname, this._port);
            DB mongoDb = mongo.getDB(this._databaseName);
            if (this._username != null && this._password != null && !(authenticated = mongoDb.authenticate(this._username, this._password))) {
                logger.warn("Autheticate returned false!");
            }
            MongoDbDataContext dataContext = this._tableDefs == null || this._tableDefs.length == 0 ? new MongoDbDataContext(mongoDb) : new MongoDbDataContext(mongoDb, this._tableDefs);
            return new UpdateableDatastoreConnectionImpl<MongoDbDataContext>(dataContext, this, new Closeable[0]);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Failed to connect to MongoDB instance: " + e.getMessage(), e);
        }
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public char[] getPassword() {
        return this._password;
    }

    public SimpleTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._databaseName);
        identifiers.add(this._hostname);
        identifiers.add(this._port);
        identifiers.add(this._username);
        identifiers.add(this._password);
        identifiers.add(this._tableDefs);
    }
}

