/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.Closeable;
import org.apache.metamodel.salesforce.SalesforceDataContext;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.connection.UsernameDatastore;

public class SalesforceDatastore
extends UsageAwareDatastore<SalesforceDataContext>
implements UpdateableDatastore,
UsernameDatastore {
    private static final long serialVersionUID = 1L;
    private final String _username;
    private final String _password;
    private final String _securityToken;

    public SalesforceDatastore(String name, String username, String password, String securityToken) {
        super(name);
        this._username = username;
        this._password = password;
        this._securityToken = securityToken;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getSecurityToken() {
        return this._securityToken;
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected UsageAwareDatastoreConnection<SalesforceDataContext> createDatastoreConnection() {
        SalesforceDataContext dataContext = new SalesforceDataContext(this._username, this._password, this._securityToken);
        return new UpdateableDatastoreConnectionImpl<SalesforceDataContext>(dataContext, this, new Closeable[0]);
    }

    @Override
    public String toString() {
        return "SalesforceDatastore[username=" + this._username + "]";
    }
}

