/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.data;

import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.AbstractInputColumn;
import org.datacleaner.util.ReflectionUtils;

public final class MetaModelInputColumn
extends AbstractInputColumn<Object> {
    private static final long serialVersionUID = 1L;
    private final Column _column;

    public MetaModelInputColumn(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        this._column = column;
    }

    public <E> InputColumn<E> narrow(Class<E> e) {
        Class javaEquivalentClass = this._column.getType().getJavaEquivalentClass();
        if (ReflectionUtils.is(javaEquivalentClass, e)) {
            return this;
        }
        throw new IllegalArgumentException("Can only narrow this column to supertypes of: " + javaEquivalentClass);
    }

    public String getName() {
        return this._column.getName();
    }

    @Override
    protected Column getPhysicalColumnInternal() {
        return this._column;
    }

    @Override
    protected boolean equalsInternal(AbstractInputColumn<?> that) {
        MetaModelInputColumn that2 = (MetaModelInputColumn)that;
        return this._column.equals(that2._column);
    }

    public Class<? extends Object> getDataType() {
        ColumnType type = this._column.getType();
        if (type == null) {
            return null;
        }
        if (type == ColumnType.CLOB) {
            return String.class;
        }
        if (type == ColumnType.BLOB) {
            return byte[].class;
        }
        return type.getJavaEquivalentClass();
    }

    @Override
    protected int hashCodeInternal() {
        return this._column.hashCode();
    }

    public String toString() {
        return "MetaModelInputColumn[" + this._column.getQualifiedLabel() + "]";
    }
}

