/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.database;

import java.io.File;
import java.io.Serializable;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.vfs2.FileObject;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Func;
import org.datacleaner.database.DatabaseDriverState;
import org.datacleaner.database.DriverWrapper;
import org.datacleaner.extensions.ClassLoaderUtils;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.VFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserDatabaseDriver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(UserDatabaseDriver.class);
    private transient Driver _driverInstance;
    private transient Driver _registeredDriver;
    private transient boolean _loaded = false;
    private final File[] _files;
    private final String _driverClassName;

    public UserDatabaseDriver(FileObject[] files, String driverClassName) {
        this(UserDatabaseDriver.convert(files), driverClassName);
    }

    private static File[] convert(FileObject[] files) {
        return CollectionUtils.map((Object[])files, (Func)new Func<FileObject, File>(){

            public File eval(FileObject arg) {
                return VFSUtils.toFile(arg);
            }
        }).toArray(new File[0]);
    }

    public UserDatabaseDriver(File[] files, String driverClassName) {
        if (files == null) {
            throw new IllegalStateException("Driver file(s) cannot be null");
        }
        if (driverClassName == null) {
            throw new IllegalStateException("Driver class name cannot be null");
        }
        this._files = files;
        this._driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public File[] getFiles() {
        return Arrays.copyOf(this._files, this._files.length);
    }

    public UserDatabaseDriver loadDriver() throws IllegalStateException {
        if (!this._loaded) {
            Class<?> loadedClass;
            ClassLoader driverClassLoader = ClassLoaderUtils.createClassLoader(this._files);
            try {
                loadedClass = Class.forName(this._driverClassName, true, driverClassLoader);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException("Could not load driver class", e);
            }
            logger.info("Loaded class: {}", (Object)loadedClass.getName());
            if (ReflectionUtils.is(loadedClass, Driver.class)) {
                this._driverInstance = (Driver)ReflectionUtils.newInstance(loadedClass);
                this._registeredDriver = new DriverWrapper(this._driverInstance);
                try {
                    DriverManager.registerDriver(this._registeredDriver);
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Could not register driver", e);
                }
            } else {
                throw new IllegalStateException("Class is not a Driver class: " + this._driverClassName);
            }
            this._loaded = true;
        }
        return this;
    }

    public void unloadDriver() {
        try {
            DriverManager.deregisterDriver(this._registeredDriver);
            this._registeredDriver = null;
            this._driverInstance = null;
            this._loaded = false;
        }
        catch (SQLException e) {
            logger.error("Exception occurred while unloading driver: " + this._driverClassName, (Throwable)e);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public DatabaseDriverState getState() {
        if (this._loaded) {
            return DatabaseDriverState.INSTALLED_WORKING;
        }
        return DatabaseDriverState.INSTALLED_NOT_WORKING;
    }
}

