/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import javax.inject.Named;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.descriptors.SimpleComponentDescriptor;
import org.datacleaner.util.ReflectionUtils;

abstract class AbstractComponentDescriptor<B>
extends SimpleComponentDescriptor<B>
implements ComponentDescriptor<B> {
    private static final long serialVersionUID = 1L;
    private final boolean _requireInputColumns;
    private final String _displayName;

    public AbstractComponentDescriptor(Class<B> componentClass, boolean requireInputColumns) {
        super(componentClass);
        this._requireInputColumns = requireInputColumns;
        this._displayName = this.determineDisplayName();
    }

    private String determineDisplayName() {
        Class componentClass = this.getComponentClass();
        Named named = this.getAnnotation(Named.class);
        String displayName = named == null ? this.getDisplayNameIfNotNamed(componentClass) : named.value();
        if (displayName == null) {
            displayName = "";
        }
        if ("".equals(displayName = displayName.trim())) {
            displayName = ReflectionUtils.explodeCamelCase(componentClass.getSimpleName(), false);
        }
        return displayName;
    }

    protected abstract String getDisplayNameIfNotNamed(Class<?> var1);

    @Override
    public final String getDisplayName() {
        if (this._displayName == null) {
            return this.determineDisplayName();
        }
        return this._displayName;
    }

    @Override
    protected abstract Class<? extends ComponentSuperCategory> getDefaultComponentSuperCategoryClass();

    @Override
    protected void visitClass() {
        super.visitClass();
        if (this._requireInputColumns) {
            int numConfiguredColumns = 0;
            int numConfiguredColumnArrays = 0;
            for (ConfiguredPropertyDescriptor cd : this._configuredProperties) {
                if (!cd.isInputColumn()) continue;
                if (cd.isArray()) {
                    ++numConfiguredColumnArrays;
                    continue;
                }
                ++numConfiguredColumns;
            }
            int totalColumns = numConfiguredColumns + numConfiguredColumnArrays;
            if (totalColumns == 0) {
                throw new DescriptorException(this.getComponentClass() + " does not define a @Configured InputColumn or InputColumn-array");
            }
        }
    }
}

