/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.Filter;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RenderingFormat;
import org.datacleaner.api.Transformer;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ComponentDescriptorsUpdatedListener;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.descriptors.RendererBeanDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;

public abstract class AbstractDescriptorProvider
implements DescriptorProvider {
    private final boolean _autoDiscover;
    private Set<ComponentDescriptorsUpdatedListener> _componentDescriptorsUpdatedListeners = Collections.newSetFromMap(new WeakHashMap());

    @Deprecated
    public AbstractDescriptorProvider() {
        this(false);
    }

    public AbstractDescriptorProvider(boolean autoLoadDescriptorClasses) {
        this._autoDiscover = autoLoadDescriptorClasses;
    }

    @Override
    public final AnalyzerDescriptor<?> getAnalyzerDescriptorByDisplayName(String name) {
        return this.getBeanDescriptorByDisplayName(name, this.getAnalyzerDescriptors());
    }

    @Override
    public final <A extends Analyzer<?>> AnalyzerDescriptor<A> getAnalyzerDescriptorForClass(Class<A> analyzerBeanClass) {
        for (AnalyzerDescriptor<?> descriptor : this.getAnalyzerDescriptors()) {
            if (descriptor.getComponentClass() != analyzerBeanClass) continue;
            return descriptor;
        }
        return this.notFoundAnalyzer(analyzerBeanClass);
    }

    @Override
    public final FilterDescriptor<?, ?> getFilterDescriptorByDisplayName(String name) {
        return this.getBeanDescriptorByDisplayName(name, this.getFilterDescriptors());
    }

    @Override
    public final <F extends Filter<C>, C extends Enum<C>> FilterDescriptor<F, C> getFilterDescriptorForClass(Class<F> filterClass) {
        return this.getFilterBeanDescriptorForClassUnbounded(filterClass);
    }

    protected final FilterDescriptor<?, ?> getFilterBeanDescriptorForClassUnbounded(Class<?> filterClass) {
        for (FilterDescriptor<?, ?> descriptor : this.getFilterDescriptors()) {
            if (filterClass != descriptor.getComponentClass()) continue;
            return descriptor;
        }
        return this.notFoundFilter(filterClass);
    }

    @Override
    public final <R extends Renderer<?, ?>> RendererBeanDescriptor<R> getRendererBeanDescriptorForClass(Class<R> rendererBeanClass) {
        for (RendererBeanDescriptor<?> descriptor : this.getRendererBeanDescriptors()) {
            if (descriptor.getComponentClass() != rendererBeanClass) continue;
            RendererBeanDescriptor<?> result = descriptor;
            return result;
        }
        return this.notFoundRenderer(rendererBeanClass);
    }

    @Override
    public final TransformerDescriptor<?> getTransformerDescriptorByDisplayName(String name) {
        return this.getBeanDescriptorByDisplayName(name, this.getTransformerDescriptors());
    }

    @Override
    public final <T extends Transformer> TransformerDescriptor<T> getTransformerDescriptorForClass(Class<T> transformerClass) {
        for (TransformerDescriptor<?> descriptor : this.getTransformerDescriptors()) {
            if (descriptor.getComponentClass() != transformerClass) continue;
            return descriptor;
        }
        return this.notFoundTransformer(transformerClass);
    }

    @Override
    public final Collection<RendererBeanDescriptor<?>> getRendererBeanDescriptorsForRenderingFormat(Class<? extends RenderingFormat<?>> renderingFormat) {
        ArrayList result = new ArrayList();
        Collection<RendererBeanDescriptor<?>> descriptors = this.getRendererBeanDescriptors();
        for (RendererBeanDescriptor<?> descriptor : descriptors) {
            Class descriptorsRenderingFormat = descriptor.getRenderingFormat();
            if (descriptorsRenderingFormat != renderingFormat) continue;
            result.add(descriptor);
        }
        return result;
    }

    private <E extends ComponentDescriptor<?>> E getBeanDescriptorByDisplayName(String name, Collection<E> descriptors) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        for (ComponentDescriptor descriptor : descriptors) {
            String displayName = descriptor.getDisplayName();
            if (!name.equals(displayName)) continue;
            return (E)descriptor;
        }
        for (ComponentDescriptor descriptor : descriptors) {
            Object[] aliases = descriptor.getAliases();
            if (!ArrayUtils.contains((Object[])aliases, (Object)name)) continue;
            return (E)descriptor;
        }
        return null;
    }

    private <A extends Analyzer<?>> AnalyzerDescriptor<A> notFoundAnalyzer(Class<A> analyzerClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofAnalyzer(analyzerClass);
    }

    private FilterDescriptor<?, ?> notFoundFilter(Class<?> filterClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofFilterUnbound(filterClass);
    }

    private <R extends Renderer<?, ?>> RendererBeanDescriptor<R> notFoundRenderer(Class<R> rendererClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofRenderer(rendererClass);
    }

    private <T extends Transformer> TransformerDescriptor<T> notFoundTransformer(Class<T> transformerClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofTransformer(transformerClass);
    }

    @Override
    public Collection<? extends ComponentDescriptor<?>> getComponentDescriptors() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.getTransformerDescriptors());
        result.addAll(this.getFilterDescriptors());
        result.addAll(this.getAnalyzerDescriptors());
        return result;
    }

    @Override
    public Set<ComponentSuperCategory> getComponentSuperCategories() {
        TreeSet<ComponentSuperCategory> result = new TreeSet<ComponentSuperCategory>();
        Collection<ComponentDescriptor<?>> descriptors = this.getComponentDescriptors();
        for (ComponentDescriptor<?> componentDescriptor : descriptors) {
            ComponentSuperCategory superCategory = componentDescriptor.getComponentSuperCategory();
            result.add(superCategory);
        }
        return result;
    }

    @Override
    public Collection<? extends ComponentDescriptor<?>> getComponentDescriptorsOfSuperCategory(ComponentSuperCategory category) {
        if (category == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        Collection<ComponentDescriptor<?>> descriptors = this.getComponentDescriptors();
        for (ComponentDescriptor<?> componentDescriptor : descriptors) {
            if (!category.equals(componentDescriptor.getComponentSuperCategory())) continue;
            result.add(componentDescriptor);
        }
        return result;
    }

    protected void notifyComponentDescriptorsUpdatedListeners() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = AbstractDescriptorProvider.this._componentDescriptorsUpdatedListeners;
                synchronized (set) {
                    for (ComponentDescriptorsUpdatedListener listener : AbstractDescriptorProvider.this._componentDescriptorsUpdatedListeners) {
                        listener.componentDescriptorsUpdated();
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponentDescriptorsUpdatedListener(ComponentDescriptorsUpdatedListener listener) {
        Set<ComponentDescriptorsUpdatedListener> set = this._componentDescriptorsUpdatedListeners;
        synchronized (set) {
            this._componentDescriptorsUpdatedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComponentDescriptorsUpdatedListener(ComponentDescriptorsUpdatedListener listener) {
        Set<ComponentDescriptorsUpdatedListener> set = this._componentDescriptorsUpdatedListeners;
        synchronized (set) {
            this._componentDescriptorsUpdatedListeners.remove(listener);
        }
    }
}

