/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.datacleaner.api.Alias;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.Filter;
import org.datacleaner.api.QueryOptimizedFilter;
import org.datacleaner.components.categories.TransformSuperCategory;
import org.datacleaner.descriptors.AbstractComponentDescriptor;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.util.ReflectionUtils;
import org.eobjects.analyzer.beans.api.FilterBean;

final class AnnotationBasedFilterComponentDescriptor<F extends Filter<C>, C extends Enum<C>>
extends AbstractComponentDescriptor<F>
implements FilterDescriptor<F, C> {
    private static final long serialVersionUID = 1L;

    protected AnnotationBasedFilterComponentDescriptor(Class<F> filterClass) throws DescriptorException {
        super(filterClass, false);
        if (!ReflectionUtils.is(filterClass, Filter.class)) {
            throw new DescriptorException(filterClass + " does not implement " + Filter.class.getName());
        }
        this.visitClass();
    }

    @Override
    protected String getDisplayNameIfNotNamed(Class<?> cls) {
        FilterBean annotation = ReflectionUtils.getAnnotation(cls, FilterBean.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    @Override
    protected Class<? extends ComponentSuperCategory> getDefaultComponentSuperCategoryClass() {
        return TransformSuperCategory.class;
    }

    public Class<C> getOutcomeCategoryEnum() {
        Class<?> typeParameter = ReflectionUtils.getTypeParameter(this.getComponentClass(), Filter.class, 0);
        if (typeParameter == null) {
            throw new IllegalStateException("Could not determine Filter's category enum type");
        }
        return typeParameter;
    }

    public EnumSet<C> getOutcomeCategories() {
        Class<C> categoryEnum = this.getOutcomeCategoryEnum();
        return EnumSet.allOf(categoryEnum);
    }

    public Set<String> getOutcomeCategoryNames() {
        EnumSet<C> enumSet = this.getOutcomeCategories();
        HashSet<String> result = new HashSet<String>();
        for (Enum category : enumSet) {
            result.add(category.name());
        }
        return result;
    }

    public Enum<C> getOutcomeCategoryByName(String categoryName) {
        if (categoryName == null) {
            return null;
        }
        EnumSet<C> categories = this.getOutcomeCategories();
        for (Enum c : categories) {
            if (!c.name().equals(categoryName)) continue;
            return c;
        }
        for (Enum c : categories) {
            String[] aliases;
            Alias aliasAnnotation = ReflectionUtils.getAnnotation(c, Alias.class);
            if (aliasAnnotation == null) continue;
            for (String alias : aliases = aliasAnnotation.value()) {
                if (!categoryName.equals(alias)) continue;
                return c;
            }
        }
        return null;
    }

    public boolean isQueryOptimizable() {
        return ReflectionUtils.is(this.getComponentClass(), QueryOptimizedFilter.class);
    }

    @Override
    public boolean isDistributable() {
        Distributed annotation = this.getAnnotation(Distributed.class);
        if (annotation != null) {
            return annotation.value();
        }
        return !this.isQueryOptimizable();
    }
}

